#ifdef __
#undef __
#endif

#ifdef __STDC__
#define __(X) X
#else
#define __(X) ()
#endif

/*
 * some systems define strchr/strrchr in terms of the (V7/BSD) functions
 * index/rindex.  Some systems do the opposite.  The #define-style aliasing
 * sometimes interferes with function prototypes.
 *
 * to solve this problem we #undef strchr/strrchr and define our own
 * implementations of these in libbondo.a
 * 
 * XXX actually, we should use the system's implementation of strchr/strrchr
 * if it has one, and the bondo one only if not.  But then we would need
 * two bondo libraries -- one to *override* bogus functions in libc, and
 * another to catch the ones that weren't supplied by the vendor.
 */

#ifdef strchr
#undef strchr
#endif
#ifdef strrchr
#undef strrchr
#endif

char *strchr __((const char *, int));
char *strdup __((const char *));
char *strerror __((int errno));
char *strrchr __((const char *, int));

#undef __
