/*
 * definitions for instrumented malloc package
 *
 * $Id$
 *
 * $Log$
 */

#ifndef IMALLOC_INCLUDED

#ifdef __
#undef __
#endif
#if defined(__STDC__) || defined(FUNCPROTO)
#define __(x) x
#else
#define __(x) ()
#endif

/* type declarations go here */

/* #define DEBUG_MALLOC */
/* #define SUN_DEBUG_MALLOC */

/* function declarations go here */

#ifdef DEBUG_MALLOC
/*
 * declarations for the debugging malloc library
 */
void *x_malloc __((int size, char *file, int line));
void *x_xmalloc __((int size, char *file, int line));
void *x_calloc __((int nitems, int size, char *file, int line));
void *x_realloc __((void *ptr, int newsize));
char *x_strdup __((char *string, char *file, int line));
#else /* DEBUG_MALLOC */
/*
 * declare the real malloc functions.  If the system has
 * a <malloc.h> file, use that; else, define our own.
 */
#ifdef NO_MALLOC_H
void *malloc __((const char *));
void *calloc __((int nitems, int size));
void *realloc __((void *, int size));
#else /* NO_MALLOC_H */
#include <malloc.h>
#endif /* NO_MALLOC_H */
#endif /* DEBUG_MALLOC */

void *xmalloc __((int size, char *file, int line));

#undef __

#ifdef DEBUG_MALLOC
#define MALLOC(x) x_malloc(x,__FILE__,__LINE__)
#define XMALLOC(x,t) (t *) x_xmalloc(((x) * sizeof(t)),__FILE__,__LINE__)
#define FREE x_free
#define REALLOC(x,y) x_realloc(x,y)
#define CALLOC(n,s) x_calloc((n),(s),__FILE__,__LINE__)
#define STRDUP(s) x_strdup(s,__FILE__,__LINE__)
#define TALLOC(n,t) (t *) x_malloc((n) * sizeof (t),__FILE__,__LINE__)
#define TREALLOC(p,n,t) (t *) REALLOC ((p), (n) * sizeof(t))
#else
#define MALLOC(x) malloc(x)
#define XMALLOC(x,t) (t *) xmalloc(((x) * sizeof(t)),__FILE__,__LINE__)
#define FREE(x) free(x)
/* #define FREE(x) do { extern char *end; if ((x) < end) abort(); else free (x); } while (0) */
#define REALLOC(x,y) realloc((x),(y))
#define CALLOC(n,s) calloc((n),(s))
#define STRDUP(s) strdup(s)
#define TALLOC(n,t) (t *) malloc((n) * sizeof (t))
#define TREALLOC(p,n,t) (t *) realloc ((p), (n) * sizeof(t))
#endif

#define IMALLOC_INCLUDED
#endif /* IMALLOC_INCLUDED */

