#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cstrbs2d(int ConTxt, char *scope, char *top, char *uplo, char *diag,
              int m, int n, float *A, int lda)
#else
void strbs2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag,
              int *m, int *n, float *A, int *lda)
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Broadcast/send for trapezoidal real arrays.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  SCOPE   (input) Ptr to char
 *          Limit the scope of the operation.
 *          = 'R' :   Operation is performed by a process row.
 *          = 'C' :   Operation is performed by a process column.
 *          = 'A' :   Operation is performed by all processes in grid.
 *
 *  TOP     (input) Ptr to char
 *          Controls fashion in which messages flow within the operation.
 *
 *  UPLO    (input) Ptr to char
 *          Specifies the part of the matrix to be sent.
 *          = 'U':      Upper trapezoidal part
 *          ELSE :      Lower trapezoidal part
 *
 *  DIAG    (input) Ptr to char
 *          Specifies whether the matrix is unit diagonal or not.
 *          = 'U':      Matrix is unit diagonal, diagonal not communicated.
 *          ELSE :      Matrix is not unit diagonal, diagonal is communicated.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (input) Ptr to real two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *          If UPLO = 'U', only the upper trapezoid is accessed;
 *          if UPLO = 'L', only the lower trapezoid is accessed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00(int, int, char *, char, char, char, int, int, int, int,
                   int *, int *);
#endif
   void tvcopy4(char, char, int, int, int *, int, int *);
   int Ahyp_bs(BLACSCONTEXT *, char, BLACBUFF *, int);
   int Aidring_bs(BLACSCONTEXT *, char, BLACBUFF *, int, int);
   int Asring_bs(BLACSCONTEXT *, char, BLACBUFF *, int);
   int Ampath_bs(BLACSCONTEXT *, char, BLACBUFF *, int, int);
   int Atree_bs(BLACSCONTEXT *, char, BLACBUFF *, int, int);
   int Shyp_bs(BLACSCONTEXT *, char, char *, int);
   int Sidring_bs(BLACSCONTEXT *, char, char *, int, int);
   int Ssring_bs(BLACSCONTEXT *, char, char *, int);
   int Smpath_bs(BLACSCONTEXT *, char, char *, int, int);
   int Stree_bs(BLACSCONTEXT *, char, char *, int, int);
   void UpdateBuffs(BLACBUFF *);
   BLACBUFF *getbuff(int);
   int BuffIsFree(BLACBUFF *, int);

   char ttop, tscope, tuplo, tdiag;
   BLACBUFF *bp=NULL;
   int error, length, tlda;
   BLACSCONTEXT *ctxt;
/*
 * get context, lowcase char variables, and perform parameter checking
 */
   MGetConTxt(Mpval(ConTxt), ctxt);
   ttop = Mlowcase(*top);
   tscope = Mlowcase(*scope);
   tuplo = Mlowcase(*uplo);
   tdiag = Mlowcase(*diag);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_BS, __FILE__, 'a', tuplo, tdiag, Mpval(m),
              Mpval(n), Mpval(lda), 0, NULL, NULL);
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);
   trsize(tdiag, Mpval(m), Mpval(n), sizeof(float), length);
   bp = getbuff(length);
   stvcopy(tuplo, tdiag, Mpval(m), Mpval(n), A, tlda, bp->Buff);

/*
 * Call correct topology for BS/BR
 */
   switch(ttop)
   {
   case ' ':
      if (bp == NULL)
         error = Stree_bs(ctxt, tscope, (char *) A, length, 2);
      else
         error = Atree_bs(ctxt, tscope, bp, length, 2);
      break;
   case 'h':
      if (bp == NULL)
      {
         error = Shyp_bs(ctxt, tscope, (char *) A, length);
         if (error == NPOW2)
            error = Stree_bs(ctxt, tscope, (char *) A, length, 2);
      }
      else
      {
         error = Ahyp_bs(ctxt, tscope, bp, length);
         if (error == NPOW2)
            error = Atree_bs(ctxt, tscope, bp, length, 2);
      }
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      if (bp == NULL)
         error = Stree_bs(ctxt, tscope, (char *) A, length, ttop-47);
      else
         error = Atree_bs(ctxt, tscope, bp, length, ttop-47);
      break;
   case 't':
      if (bp == NULL)
         error = Stree_bs(ctxt, tscope, (char *) A, length, ctxt->Nb_bs);
      else
         error = Atree_bs(ctxt, tscope, bp, length, ctxt->Nb_bs);
      break;
   case 'i':
      if (bp == NULL)
         error = Sidring_bs(ctxt, tscope, (char *) A, length, 1);
      else
         error = Aidring_bs(ctxt, tscope, bp, length, 1);
      break;
   case 'd':
      if (bp == NULL)
         error = Sidring_bs(ctxt, tscope, (char *) A, length, -1);
      else
         error = Aidring_bs(ctxt, tscope, bp, length, -1);
      break;
   case 's':
      if (bp == NULL)
         error = Ssring_bs(ctxt, tscope, (char *) A, length);
      else
         error = Asring_bs(ctxt, tscope, bp, length);
      break;
   case 'f':
      if (bp == NULL)
         error = Smpath_bs(ctxt, tscope, (char *) A, length, FULLCON);
      else
         error = Ampath_bs(ctxt, tscope, bp, length, FULLCON);
      break;
   case 'm':
      if (bp == NULL)
         error = Smpath_bs(ctxt, tscope, (char *) A, length, ctxt->Nr_bs);
      else
         error = Ampath_bs(ctxt, tscope, bp, length, ctxt->Nr_bs);
      break;
   default :
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown topology '%c'",*top);
   }

#if (BlacsDebugLvl > 0)
   if (error == BADSCP)
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown scope '%c'", *scope);
#endif
   UpdateBuffs(bp);

}  /* end  strbs2d_  */
