#include "Bdef.h"


#if (INTFACE == C_CALL)
void Ccgamn2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
              int lda, int *rA, int *cA, int ldia, int rdest, int cdest)
#else
void cgamn2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A,
              int *lda, int *rA, int *cA, int *ldia, int *rdest, int *cdest)
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Combine amn operation for complex rectangular matrices.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  SCOPE   (input) Ptr to char
 *          Limit the scope of the operation.
 *          = 'R' :   Operation is performed by a process row.
 *          = 'C' :   Operation is performed by a process column.
 *          = 'A' :   Operation is performed by all processes in grid.
 *
 *  TOP     (input) Ptr to char
 *          Controls fashion in which messages flow within the operation.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to complex two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RA      (output) Integer Array, dimension (LDIA, N)
 *          Contains process row that the amn of each element
 *          of A was found on: i.e., rA(1,2) contains the process
 *          row that the amn of A(1,2) was found on.
 *          Values are left on process {rdest, cdest} only, others
 *          may be modified, but not left with interesting data.
 *          If rdest == -1, then result is left on all processes in scope.
 *          If LDIA == -1, this array is not accessed, and need not exist.
 *
 *  CA      (output) Integer Array, dimension (LDIA, N)
 *          Contains process column that the amn of each element
 *          of A was found on: i.e., cA(1,2) contains the process
 *          column that the max/min of A(1,2) was found on.
 *          Values are left on process {rdest, cdest} only, others
 *          may be modified, but not left with interesting data.
 *          If rdest == -1, then result is left on all processes in scope.
 *          If LDIA == -1, this array is not accessed, and need not exist.
 *
 *  LDIA    (input) Ptr to int
 *          If (LDIA == -1), then the arrays RA and CA are not accessed.
 *          ELSE leading dimension of the arrays RA and CA.  LDIA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination of the amn.
 *          If rdest == -1, then result is left on all processes in scope.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination of the amn.
 *          If rdest == -1, then CDEST ignored.
 *
 * ------------------------------------------------------------------------
 */
{
   void TransDist(BLACSCONTEXT *, char, int, int, int *, int *, int,
                  unsigned short *, int, int);
   void tree_comb(BLACSCONTEXT *, char, int, int, int, BLACBUFF *, BLACBUFF *,
                  int, int, VVFUNPTR);
   void BE_comb(BLACSCONTEXT *, char, int, int, BLACBUFF *, BLACBUFF *,
                VVFUNPTR);
   void cvvamn(int, char *, char *);
   void cvvamn2(int, char *, char *);
   void mvcopy8(int, int, double *, int, double *);
   void vmcopy8(int, int, double *, int, double *);
   void UpdateBuffs(BLACBUFF *);
   BLACBUFF *getbuff(int);
   int BuffIsFree(BLACBUFF *, int);
#if (BlacsDebugLvl > 0)
   void ArgCheck00(int, int, char *, char, char, char, int, int, int, int,
                   int *, int *);
#endif
/*
 *  Variable Declarations
 */
   VVFUNPTR vvop;
   BLACBUFF *bp, *bp2;
   BLACSCONTEXT *ctxt;
   char ttop, tscope;
   int i, N, length, tlda, tldia, trdest;
   unsigned short *dist, mydist;
   extern BLACBUFF *ActiveQ00;
   extern BLACBUFF AuxBuff00;

   MGetConTxt(Mpval(ConTxt), ctxt);
   ttop = Mlowcase(*top);
   tscope = Mlowcase(*scope);
   if (Mpval(ldia) < 1) vvop = cvvamn2;
   else vvop = cvvamn;

   if (Mpval(cdest) == -1) trdest = -1;
   else trdest = Mpval(rdest);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_COMB, __FILE__, tscope, 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, &trdest, Mpaddress(cdest));
   if (Mpval(ldia) < Mpval(m))
   {
      if (Mpval(ldia) != -1)
         BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__,
                   "LDIA too small (LDIA=%d, but M=%d)", Mpval(ldia), Mpval(m));
   }
#endif
   if (Mpval(lda) >= Mpval(m)) tlda = Mpval(lda);
   else tlda = Mpval(m);
   if (Mpval(ldia) < Mpval(m)) tldia = Mpval(m);
   else tldia = Mpval(ldia);

   N = Mpval(m) * Mpval(n);
/*
 * If process who has amn is to be communicated, must set up distance
 * vector after value vector
 */
   if (Mpval(ldia) != -1)
   {
      length = N * ( sizeof(SCOMPLEX) + sizeof(short) );
/*
 *    Get both buffs on 8-byte boundary
 */
      i = length % 8;
      if (i) i = 2 * (length + 8 - i);
      else i = 2 * length;
      bp = getbuff(i);
      bp2 = &AuxBuff00;
      bp2->Buff = &bp->Buff[i/2];
      cmvcopy(Mpval(m), Mpval(n), A, tlda, bp->Buff);
      switch(tscope)
      {
      case 'r':
         if (trdest == -1) mydist = ctxt->mycol;
         else mydist = (ctxt->npcol+ctxt->mycol-Mpval(cdest))%ctxt->npcol;
         break;
      case 'c':
         if (trdest == -1) mydist = ctxt->myrow;
         else mydist = (ctxt->nprow+ctxt->myrow-Mpval(rdest))%ctxt->nprow;
         break;
      case 'a':
         if (trdest == -1) mydist = ctxt->vIam;
         else
         {
            i = Mvkpnum(ctxt, Mpval(rdest), Mpval(cdest));
            mydist = (ctxt->Ng+ctxt->vIam-i)%ctxt->Ng;
         }
         break;
      }
      dist = (unsigned short *) &bp->Buff[N*sizeof(SCOMPLEX)];
      for (i=0; i < N; i++) dist[i] = mydist;
   }
   else
   {
      length = N * sizeof(SCOMPLEX);
      if ( (Mpval(m) == tlda) || (Mpval(n) == 1) )
      {
         bp = &AuxBuff00;
         bp->Buff = (char *) A;
         bp2 = getbuff(length);
      }
      else
      {
         bp = getbuff(length*2);
         bp2 = &AuxBuff00;
         bp2->Buff = &bp->Buff[length];
         cmvcopy(Mpval(m), Mpval(n), A, tlda, bp->Buff);
      }
   }

   switch(ttop)
   {
   case ' ':
      tree_comb(ctxt, tscope, 2, N, length, bp, bp2, trdest,
                Mpval(cdest), vvop);
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      tree_comb(ctxt, tscope, ttop-47, N, length, bp, bp2, trdest,
                Mpval(cdest), vvop);
      break;
   case 'f':
      tree_comb(ctxt, tscope, FULLCON, N, length, bp, bp2, trdest,
                Mpval(cdest), vvop);
      break;
   case 't':
      tree_comb(ctxt, tscope, ctxt->Nb_co, N, length, bp, bp2,
                trdest, Mpval(cdest), vvop);
      break;
   case 'h':
/*
 *    Use bidirectional exchange if everyone wants answer
 */
      if ( (trdest == -1) && !(ctxt->TopsCohrnt) )
         BE_comb(ctxt, tscope, N, length, bp, bp2, vvop);
      else
         tree_comb(ctxt, tscope, 2, N, length, bp, bp2, trdest,
                   Mpval(cdest), vvop);
      break;
   default :
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown topology '%c'",*top);
   }

/*
 * If I am selected to receive answer
 */
   if ( ( (ctxt->myrow == trdest) && (ctxt->mycol == Mpval(cdest)) ) ||
        (trdest == -1) )
   {
/*
 *    Translate the distances stored in the latter part of bp->Buff into
 *    process grid coordinates, and output these coordinates in the
 *    arrays rA and cA.
 */
      if (Mpval(ldia) != -1)
         TransDist(ctxt, tscope, Mpval(m), Mpval(n), rA, cA, tldia,
                   dist, trdest, Mpval(cdest));
/*
 *    Unpack the amn array
 */
      cvmcopy(Mpval(m), Mpval(n), A, tlda, bp->Buff);
   }
   if (bp == &AuxBuff00)
   {
      if (ActiveQ00) UpdateBuffs(NULL);
      BuffIsFree(bp, 1);
   }
   else UpdateBuffs(bp);
}
