#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cblacs_gridmap(int *ConTxt, int *usermap, int ldup, int nprow0, int npcol0)
#else
void blacs_gridmap_(int *ConTxt, int *usermap, int *ldup, int *nprow0,
                    int *npcol0)
#endif
{
#if (INTFACE == C_CALL)
   void Cblacs_pinfo(int *, int *);
   void Cblacs_get(int, int, int *);
#else
   void blacs_pinfo_(int *, int *);
   void blacs_get_(int *, int *, int *);
#endif
   void Ssend2d00(BLACSCONTEXT *, char *, int, int, int, int);
   void Srecv2d00(BLACSCONTEXT *, char *, int, int);

   int i, j, k, msgid, ctxtMinID, *iptr;
   int Ng, nprow, npcol;
   extern int DONTCARE, ALLMSG;        /* wildcards for message source and ID */
   BLACSCONTEXT *ctxt, **tCTxts;
   extern BLACSCONTEXT **MyConTxts00;
   extern BLACBUFF AuxBuff00;
   extern int Iam00, Np00, minID00, maxID00, availID00, MaxNCtxt00;

/*
 * If first call to blacs_gridmap
 */
   if (availID00 == -1)
   {
#if (INTFACE == C_CALL)
      Cblacs_pinfo(&Iam00, &Np00);
#else
      blacs_pinfo_(&Iam00, &Np00);
#endif
      iptr = (int *) malloc(3 * sizeof(int));
      iptr[0] = SGET_MSGIDS;
#if (INTFACE == C_CALL)
      Cblacs_get(*iptr, *iptr, &iptr[1]);/* set up message ids */
#else
      blacs_get_(iptr, iptr, &iptr[1]);  /* set up message ids */
#endif
      mpc_task_query(iptr, 2, 3);
      DONTCARE = iptr[0];
      ALLMSG   = iptr[1];
      free(iptr);
      AuxBuff00.nAops = 0;
      AuxBuff00.Aops = (int *) malloc(Np00*sizeof(*AuxBuff00.Aops));
   }

#if (BlacsDebugLvl > 0)
   if (*ConTxt != NOTINCONTEXT)
      BlacsWarn(-1, -1, "BLACS_GRIDINIT/BLACS_GRIDMAP",
      "Failure to call BLACS_GET before grid creation makes code non-portable");
#endif

   nprow = Mpval(nprow0);
   npcol = Mpval(npcol0);
   Ng = nprow * npcol;
   if ( (Ng > Np00) || (nprow < 1) || (npcol < 1) )
      BlacsErr(-1, -1, "BLACS_GRIDINIT/BLACS_GRIDMAP",
               "Illegal grid (%d x %d), #procs=%d", nprow, npcol, Np00);

/*
 * Weed out callers who are not participating in present grid
 */
   for (k=0; k < Ng; k++)
   {
      i = k % nprow;
      j = k / nprow;
      if (usermap[j*Mpval(ldup)+i] == Iam00) break;
   }
   if (k == Ng)
   {
      *ConTxt = NOTINCONTEXT;
      return;
   }

/*
 * ==================================================
 * Get new context and add it to my array of contexts
 * ==================================================
 */
   ctxt = (BLACSCONTEXT *) malloc(sizeof(BLACSCONTEXT));
/*
 * Find free slot in my context array
 */
   for (i=0; i < MaxNCtxt00; i++) if (MyConTxts00[i] == NULL) break;
/*
 * Get bigger context pointer array, if needed
 */
   if (i == MaxNCtxt00)
   {
      j = MaxNCtxt00 + MAXNCTXT;
      tCTxts = (BLACSCONTEXT **) malloc(j * sizeof(*tCTxts));
      for (i=0; i < MaxNCtxt00; i++) tCTxts[i] = MyConTxts00[i];
      MaxNCtxt00 = j;
      for(j=i; j < MaxNCtxt00; j++) tCTxts[j] = NULL;
      if (MyConTxts00) free(MyConTxts00);
      MyConTxts00 = tCTxts;
   }
   MyConTxts00[i] = ctxt;
   *ConTxt = i;

   ctxt->nprow = nprow;
   ctxt->npcol = npcol;
   ctxt->Ng = Ng;
   ctxt->Nr_bs = ctxt->Nr_co = 1;
   ctxt->Nb_bs = ctxt->Nb_co = 2;
   ctxt->proc2coord = (int *) malloc(Np00*sizeof(int));
   ctxt->coord2proc = (int *) malloc(Ng*sizeof(int));
   ctxt->TopsRepeat = ctxt->TopsCohrnt = 0;

/*
 * Define process grid. NOTE: fortran uses column-major order.
 */
   for (j=0; j < npcol; j++)
   {
      for (i=0; i < nprow; i++)
      {
         k = i * npcol + j;
         ctxt->coord2proc[k] = usermap[j*Mpval(ldup)+i];
         ctxt->proc2coord[ctxt->coord2proc[k]] = k;
      }
   }
   Mpcoord(ctxt, Iam00, ctxt->myrow, ctxt->mycol);
   ctxt->vIam = Mvkpnum(ctxt, ctxt->myrow, ctxt->mycol);
/*
 * ===========================
 * Set up the message id stuff
 * ===========================
 */

/*
 * Find what I think minID should be
 */
   if (availID00 != -1) ctxtMinID = availID00;
   else ctxtMinID = minID00 + Np00;

#if (BlacsDebugLvl > 0)
   j = Ng + 5;
#else
   j = 3;
#endif
   iptr = (int *) malloc(j * sizeof(int));

   if (ctxt->vIam == 0)
   {
/*
 *    Receive grid and start ID from other nodes
 */
      for (i=1; i < Ng; i++)
      {
         msgid = minID00 + ctxt->coord2proc[i];
         Srecv2d00(ctxt, (char *) iptr, j*sizeof(int), msgid);
         if (iptr[2] > ctxtMinID) ctxtMinID = iptr[2];
         if ( (iptr[0] != nprow) || (iptr[1] != npcol) )
            BlacsErr(-1, -1, "BLACS_GRIDINIT/BLACS_GRIDMAP",
                     "Process %d had %d x %d grid; correct is %d x %d",
                     ctxt->coord2proc[i], iptr[0], iptr[1], nprow, npcol);
/*
 *       If we are playing it safe, check some additional stuff
 */
#if (BlacsDebugLvl > 0)
/*
 *       Check we have same msgid range
 */
         if ( (iptr[3] != minID00) || (iptr[4] != maxID00) )
            BlacsErr(-1, -1, "BLACS_GRIDINIT/BLACS_GRIDMAP",
                     "Processes had different message ID ranges");
/*
 *       Check that we agree on mapping
 */
         for (k=0; k < Ng; k++)
         {
            if (iptr[k+5] != ctxt->coord2proc[k])
            {
               BlacsErr(-1, -1, "BLACS_GRIDINIT/BLACS_GRIDMAP",
                        "Process %d had incorrect grid map",
                        ctxt->coord2proc[k]);
            }
         }
#endif
      }
/*
 *    Send out minID for this context to use
 */
      for (i=1; i < Ng; i++)
      {
         Mvpcoord(ctxt, i, j, k);
         msgid = minID00 + ctxt->coord2proc[i];
         Ssend2d00(ctxt, (char *) &ctxtMinID, sizeof(int), j, k, msgid);
      }
   }
   else
   {
      msgid = minID00 + Iam00;
      iptr[0] = nprow;
      iptr[1] = npcol;
      iptr[2] = ctxtMinID;
#if (BlacsDebugLvl > 0)
      iptr[3] = minID00;
      iptr[4] = maxID00;
      for(k=0; k < Ng; k++) iptr[5+k] = ctxt->coord2proc[k];
#endif
      Ssend2d00(ctxt, (char *) iptr, j*sizeof(int), 0, 0, msgid);
      Srecv2d00(ctxt, (char *) &ctxtMinID, sizeof(int), msgid);
   }
   free(iptr);

/*
 * Find begining and end of this context's IDs
 */
   ctxt->minID = ctxtMinID;
   k = (maxID00 - ctxt->minID) * IDPERC;   /* # of IDs for this context */
   ctxt->maxID = ctxt->minID + k;
   availID00 = ctxt->maxID + 1;
/*
 * Set up point to point IDs (they get half the range)
 */
   j = k / 2;                           /* # of IDs for pt2pt comm */
   ctxt->SDminID = ctxt->minID;
   ctxt->SDmaxID = ctxt->minID + j;
   ctxt->IDsPerNode = j / Ng;
   ctxt->SDmyminID = ctxt->IDsPerNode * ctxt->vIam + ctxt->SDminID;
   ctxt->SDcount = (int *) malloc(Ng*sizeof(int));
   ctxt->RVcount = (int *) malloc(Ng*sizeof(int));
   for (i=0; i < Ng; i++) ctxt->SDcount[i] = ctxt->RVcount[i] = 0;
/*
 * Set up scoped IDs
 */
   k = ( (k + 1) / 2 ) / 3;                /* # of IDs for each scope */
   ctxt->RminID = ctxt->SDmaxID + 1;
   ctxt->CminID = ctxt->RminID + k;
   ctxt->AminID = ctxt->CminID + k;

   ctxt->Rcount = ctxt->RminID;
   ctxt->Ccount = ctxt->CminID;
   ctxt->Acount = ctxt->AminID;

   if (ctxt->vIam == 0)
   {
      if (ctxt->IDsPerNode < 100)
         BlacsWarn(-1, -1, "BLACS_GRIDINIT/BLACS_GRIDMAP",
                 "Point to point message IDs will be reused every %d messages",
                 ctxt->IDsPerNode);
      if ( (ctxt->CminID - ctxt->RminID) < 100 )
         BlacsWarn(-1, -1, "BLACS_GRIDINIT/BLACS_GRIDMAP",
                   "Scoped message IDs will be reused every %d operations",
                   ctxt->CminID - ctxt->RminID);
   }
}
