#include "Bdef.h"
#if (INTFACE == C_CALL)
void Cblacs_get(int ConTxt, int what, int *val)
#else
void blacs_get_(int *ConTxt, int *what, int *val)
#endif
{
   BLACSCONTEXT *ctxt;
   extern int minID00, maxID00;

   switch( Mpval(what) )
   {
   case SGET_SYSCONTXT:
      *val = NOTINCONTEXT;
      break;
   case SGET_MSGIDS:
/*
 *    On first call, find legal range of msgids
 */
      if (maxID00 < 0)
      {
         mpc_task_query(val, 2, 2);
         minID00 = val[0];
         maxID00 = val[1];
      }
      val[0] = minID00;
      val[1] = maxID00;
      break;
   case SGET_DEBUGLVL:
      *val = BlacsDebugLvl;
      break;
   case SGET_BLACSCONTXT:
      *val = NOTINCONTEXT;
      break;
   case SGET_NR_BS:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nr_bs;
      break;
   case SGET_NB_BS:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nb_bs - 1;
      break;
   case SGET_NR_CO:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nr_co;
      break;
   case SGET_NB_CO:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nb_co - 1;
      break;
   case SGET_TOPSREPEAT:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->TopsRepeat;
      break;
   case SGET_TOPSCOHRNT:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->TopsCohrnt;
      break;
   default:
      BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__, "Unknown WHAT (%d)",
                Mpval(what));
   }
}
