#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cblacs_exit(int NotDone)
#else
void blacs_exit_(int *NotDone)
#endif
{
#if (INTFACE == C_CALL)
   void Cblacs_gridexit(int ConTxt);
#else
   void blacs_gridexit_(int *ConTxt);
#endif
   void UpdateBuffs(BLACBUFF *);
   BLACBUFF *getbuff(int);
   int BuffIsFree(BLACBUFF *, int);
   BLACBUFF *bp;
   extern BLACBUFF *ReadyB00, *ActiveQ00, AuxBuff00;
   int i;
   extern int MaxNCtxt00, Np00, minID00, maxID00, availID00;
   extern BLACSCONTEXT **MyConTxts00;
/*
 * Destroy all contexts
 */
#if (INTFACE == C_CALL)
   for (i=0; i < MaxNCtxt00; i++) if (MyConTxts00[i]) Cblacs_gridexit(i);
#else
   for (i=0; i < MaxNCtxt00; i++) if (MyConTxts00[i]) blacs_gridexit_(&i);
#endif
   free(MyConTxts00);

   if (ReadyB00) free(ReadyB00);
   while (ActiveQ00 != NULL)
   {
      bp = ActiveQ00;
      BuffIsFree(bp, 1);  /* wait for async sends to complete */
      ActiveQ00 = bp->next;
      free(bp);
   }
   free (AuxBuff00.Aops);

/*
 * Reset parameters to initial values
 */
   MaxNCtxt00 = 0;
   MyConTxts00 = NULL;
   Np00 = -1;
   availID00 = -1;
   maxID00 = -1;
   ReadyB00 = NULL;
}
