#include "Bdef.h"
void mvcopy8(int m, int n, double *A, int lda, double *buff)
/*
 *  performs an 8 byte matrix to vector copy (pack)
 */
{
   int i, j;
   if ( (m == lda) || (n == 1) )
   {
      m = n * m;
      for (i=0; i < m; i++) buff[i] = A[i];
   }
   else if (m == 1)
   {
      for (j=0; j < n; j++) buff[j] = A[j*lda];
   }
   else
   {
      for (j=0; j < n; j++)
      {
         for (i=0; i < m; i++) buff[i] = A[i];
         A += lda;
         buff += m;
      }
   }
}
