#include "Bdef.h"

void UpdateBuffs(BLACBUFF *Newbp)
{
   BLACBUFF *bp, *bp2;
   extern BLACBUFF *ReadyB00, *ActiveQ00;

   if (Newbp)
   {
      if (ActiveQ00 == NULL) ActiveQ00 = Newbp->prev = Newbp;
      else
      {
	 ActiveQ00->prev->next = Newbp;
	 Newbp->prev = ActiveQ00->prev;
	 ActiveQ00->prev = Newbp;
      }
      Newbp->next = NULL;
      if (Newbp == ReadyB00) ReadyB00 = NULL;
   }
/*
 * See if any active buffers are ready for reuse.
 */
   for (bp=ActiveQ00; bp != NULL; bp = bp2)
   {
      bp2 = bp->next;
      if ( BuffIsFree(bp, 0) )  /* if all of buff's Aops are done */
      {
/*
 *       Remove bp from ActiveQ00 -- update pointers
 */
	 if (bp->next) bp->next->prev = bp->prev;
	 else ActiveQ00->prev = bp->prev;
	 if (bp != ActiveQ00) bp->prev->next = bp->next;
	 else ActiveQ00 = ActiveQ00->next;

/*
 *       If no ready buffer, inactive buff becomes ready
 */
	 if (ReadyB00 == NULL) ReadyB00 = bp;
/*
 *       If inactive buff bigger than present ready buff, release ready,
 *       and inactive buff becomes ready
 */
	 else if (ReadyB00->Len < bp->Len)
	 {
	    free(ReadyB00);
	    ReadyB00 = bp;
	 }
/*
 *       If ready buffer exists and is bigger than inactive buff,
 *       free inactive buff
 */
	 else free(bp);
      }
   }
}  /* end UpdateBuffs */
