#include "Bdef.h"

int Ssring_br(BLACSCONTEXT *ctxt, char scope, char *buff, int length, int rsrc, int csrc)
{
   void Ssend2d00(BLACSCONTEXT *, char *, int, int, int, int);
   void Srecv2d00(BLACSCONTEXT *, char *, int, int);

   int mydist;  	/* my distance from source */
   int Ng, nprow, npcol, myrow, mycol;
   int rightedge, rdest, cdest, vsrc;
   int msgid;

   Mgridinfo(ctxt, Ng, nprow, npcol, myrow, mycol);
   scope = Mlowcase(scope);
   switch(scope)
   {
   case 'r':
      msgid = Mrid(ctxt);
      mydist = (npcol + mycol - csrc) % npcol;
      rightedge = npcol/2;
      Srecv2d00(ctxt, buff, length, msgid);

      if (mydist < rightedge)   /* between source & right edge of split ring */
         Ssend2d00(ctxt, buff, length, myrow, (mycol+1)%npcol, msgid);
      else if (mydist > rightedge+1) /* between source and leftedge */
         Ssend2d00(ctxt, buff, length, myrow, (npcol+mycol-1)%npcol, msgid);
      break;

   case 'c':

      msgid = Mcid(ctxt);
      mydist = (nprow + myrow - rsrc) % nprow; /* distance from source */
      rightedge = nprow/2;
      Srecv2d00(ctxt, buff, length, msgid);

      if (mydist < rightedge)	/* between source & right edge of split ring */
         Ssend2d00(ctxt, buff, length, (myrow+1)%nprow, mycol, msgid);
      else if (mydist > rightedge+1) /* between source and leftedge */
         Ssend2d00(ctxt, buff, length, (nprow+myrow-1)%nprow, mycol, msgid);
      break;

   case 'a':

      vsrc = Mvkpnum(ctxt, rsrc, csrc);
      msgid = Maid(ctxt);
      mydist = (Ng + ctxt->vIam - vsrc) % Ng; /* distance from source */
      rightedge = Ng/2;

      Srecv2d00(ctxt, buff, length, msgid);

      if (mydist < rightedge)	/* between source & right edge of split ring */
      {
	 Mvpcoord(ctxt, (ctxt->vIam+1)%Ng, rdest, cdest);
         Ssend2d00(ctxt, buff, length,  rdest, cdest, msgid);
      }
      else if (mydist > rightedge+1) /* between source and leftedge */
      {
	 Mvpcoord(ctxt, (Ng+ctxt->vIam-1)%Ng, rdest, cdest);
         Ssend2d00(ctxt, buff, length,  rdest, cdest, msgid);
      }
      break;

   default:
      return(BADSCP);
   }
   return(0);
}
