#include "Bdef.h"

int Smpath_bs(BLACSCONTEXT *ctxt, char scope, char *buff, int length, int npaths)
{
   void Ssend2d00(BLACSCONTEXT *, char *, int, int, int, int);

   int pathlen;		/* the length of each path */
   int dist;	        /* the distance to the node closest to src on each path */
   int rdest, cdest;    /* row and col destination coordinates */
   int pdest;           /* part of dest calculation -- saves unneeded ops */
   int lastlong;	/* number of paths with extra node */
   int nrnodes;         /* number of receiving nodes ( = nnodes-1 ) */
   int Ng, nprow, npcol, myrow, mycol;
   int msgid;
   int dir, i;

   Mgridinfo(ctxt, Ng, nprow, npcol, myrow, mycol);
   if (npaths == FULLCON) npaths = Ng;
   scope = Mlowcase(scope);
   switch(scope)
   {
   case 'r':
      if (npcol < 2) return(NORV);
      msgid = Mrid(ctxt);
      if (npaths > 0)  /* paths are increasing rings */
      {
         Ssend2d00(ctxt, buff, length, myrow, (mycol+1)%npcol, msgid);
	 pdest = mycol;
	 dir = 1;
      }
      else             /* paths are decreasing rings */
      {
	 pdest = npcol + mycol;
         Ssend2d00(ctxt, buff, length, myrow, (pdest-1)%npcol, msgid);
	 dir = -1;
	 npaths = -npaths;
      }
      nrnodes = npcol - 1;
/*
 *    Ensure npaths is correct
 */
      if (npaths > nrnodes) npaths = nrnodes;
      pathlen = nrnodes / npaths;

      lastlong = (nrnodes % npaths) * (pathlen+1);  /* last node in long ring */
      if (lastlong)
      {
         for(dist=pathlen+2; dist < lastlong; dist += pathlen + 1)
            Ssend2d00(ctxt, buff, length, myrow, (pdest+dir*dist)%npcol, msgid);
      }
      else dist = pathlen+1;

      while (dist < npcol)
      {
         Ssend2d00(ctxt, buff, length, myrow, (pdest+dir*dist)%npcol, msgid);
         dist += pathlen;
      }
      break;
   case 'c':
      if (nprow < 2) return(NORV);
      msgid = Mcid(ctxt);
      if (npaths > 0)  /* paths are increasing rings */
      {
         Ssend2d00(ctxt, buff, length, (myrow+1)%nprow, mycol, msgid);
	 pdest = myrow;
	 dir = 1;
      }
      else             /* paths are decreasing rings */
      {
	 pdest = nprow + myrow;
         Ssend2d00(ctxt, buff, length, (pdest-1)%nprow, mycol, msgid);
	 dir = -1;
	 npaths = -npaths;
      }
      nrnodes = nprow - 1;
/*
 *    Ensure npaths is correct
 */
      if (npaths > nrnodes) npaths = nrnodes;
      pathlen = nrnodes / npaths;

      lastlong = (nrnodes % npaths) * (pathlen+1);  /* last node in long ring */
      if (lastlong)
      {
         for(dist=pathlen+2; dist < lastlong; dist += pathlen + 1)
            Ssend2d00(ctxt, buff, length, (pdest+dir*dist)%nprow, mycol, msgid);
      }
      else dist = pathlen+1;

      while (dist < nprow)
      {
         Ssend2d00(ctxt, buff, length, (pdest+dir*dist)%nprow, mycol, msgid);
         dist += pathlen;
      }
      break;
   case 'a':
      if (Ng < 2) return(NORV);
      msgid = Maid(ctxt);
      if (npaths > 0)  /* paths are increasing rings */
      {
         i = (ctxt->vIam+1)%Ng ;   /* contains virtual destination node */
	 Mvpcoord(ctxt, i, rdest, cdest);
         Ssend2d00(ctxt, buff, length, rdest, cdest, msgid);
	 pdest = ctxt->vIam;
	 dir = 1;
      }
      else             /* paths are decreasing rings */
      {
	 pdest = Ng + ctxt->vIam;
         i = (pdest-1) % Ng;   /* contains virtual destination node */
	 Mvpcoord(ctxt, i, rdest, cdest);
         Ssend2d00(ctxt, buff, length, rdest, cdest, msgid);
	 dir = -1;
	 npaths = -npaths;
      }
      nrnodes = Ng - 1;
/*
 *    Ensure npaths is correct
 */
      if (npaths > nrnodes) npaths = nrnodes;
      pathlen = nrnodes / npaths;

      lastlong = (nrnodes % npaths) * (pathlen+1);  /* last node in long ring */
      if (lastlong)
      {
         for(dist=pathlen+2; dist < lastlong; dist += pathlen + 1)
         {
	    i = (pdest + dir*dist) % Ng;
            Mvpcoord(ctxt, i, rdest, cdest);
            Ssend2d00(ctxt, buff, length, rdest, cdest, msgid);
         }
      }
      else dist = pathlen+1;

      while (dist < Ng)
      {
	 i = (pdest + dir*dist) % Ng;
         Mvpcoord(ctxt, i, rdest, cdest);
         Ssend2d00(ctxt, buff, length, rdest, cdest, msgid);
         dist += pathlen;
      }
      break;
   default:
      return(BADSCP);
   }
   return(0);
}
