#include "Bdef.h"

int BuffIsFree(BLACBUFF *bp, int Wait)
/*
 *  Check to see if buff is finished with async. operations.  If Wait != 0,
 *  wait for all async. operations to complete.
 */
{
   int i;
   extern int BLACOP, AOPDONE;

   if (!Wait)
   {
      for (i=0; i < bp->nAops; i++)
      {
         if (bp->Aops[i] == BLACOP) return(0);  /* blacs still using, quit */
         if (bp->Aops[i] != AOPDONE)
         {
            if (mpc_status(bp->Aops[i]) == -1) return(0);
            bp->Aops[i] = AOPDONE;
         }
      }
   }
/*
 * If want to wait for buffer to be available
 */
   else
   {
      for (i=0; i < bp->nAops; i++)
      {
         if (bp->Aops[i] == BLACOP) bp->Aops[i] = AOPDONE;
         else if (bp->Aops[i] != AOPDONE)
         {
            mpc_wait(&(bp->Aops[i]), &Wait);
            bp->Aops[i] = AOPDONE;
         }
      }
   }
   bp->nAops = 0;
   return(1);
}
