#include "Bdef.h"

int Asring_br(BLACSCONTEXT *ctxt, char scope, BLACBUFF *bp, int length, int rsrc, int csrc)
{
   void Asend2d00(BLACSCONTEXT *, BLACBUFF *, int, int, int, int);
   void Srecv2d00(BLACSCONTEXT *, char *, int, int);

   int mydist;  	/* my distance from source */
   int Ng, nprow, npcol, myrow, mycol;
   int rightedge, rdest, cdest, vsrc;
   int msgid;

   Mgridinfo(ctxt, Ng, nprow, npcol, myrow, mycol);
   scope = Mlowcase(scope);
   switch(scope)
   {
   case 'r':
      msgid = Mrid(ctxt);
      mydist = (npcol + mycol - csrc) % npcol;
      rightedge = npcol/2;
      Srecv2d00(ctxt, bp->Buff, length, msgid);

      if (mydist < rightedge)   /* between source & right edge of split ring */
         Asend2d00(ctxt, bp, length, myrow, (mycol+1)%npcol, msgid);
      else if (mydist > rightedge+1) /* between source and leftedge */
         Asend2d00(ctxt, bp, length, myrow, (npcol+mycol-1)%npcol, msgid);
      break;

   case 'c':

      msgid = Mcid(ctxt);
      mydist = (nprow + myrow - rsrc) % nprow; /* distance from source */
      rightedge = nprow/2;
      Srecv2d00(ctxt, bp->Buff, length, msgid);

      if (mydist < rightedge)	/* between source & right edge of split ring */
         Asend2d00(ctxt, bp, length, (myrow+1)%nprow, mycol, msgid);
      else if (mydist > rightedge+1) /* between source and leftedge */
         Asend2d00(ctxt, bp, length, (nprow+myrow-1)%nprow, mycol, msgid);
      break;

   case 'a':

      vsrc = Mvkpnum(ctxt, rsrc, csrc);
      msgid = Maid(ctxt);
      mydist = (Ng + ctxt->vIam - vsrc) % Ng; /* distance from source */
      rightedge = Ng/2;

      Srecv2d00(ctxt, bp->Buff, length, msgid);

      if (mydist < rightedge)	/* between source & right edge of split ring */
      {
	 Mvpcoord(ctxt, (ctxt->vIam+1)%Ng, rdest, cdest);
         Asend2d00(ctxt, bp, length,  rdest, cdest, msgid);
      }
      else if (mydist > rightedge+1) /* between source and leftedge */
      {
	 Mvpcoord(ctxt, (Ng+ctxt->vIam-1)%Ng, rdest, cdest);
         Asend2d00(ctxt, bp, length,  rdest, cdest, msgid);
      }
      break;

   default:
      return(BADSCP);
   }
   return(0);
}
