#include "Bdef.h"

int Ampath_br(BLACSCONTEXT *ctxt, char scope, BLACBUFF *bp, int length, int npaths,
             int rsrc, int csrc)
{
   void Asend2d00(BLACSCONTEXT *, BLACBUFF *, int, int, int, int);
   void Arecv2d00(BLACSCONTEXT *, BLACBUFF *, int, int);
   void Srecv2d00(BLACSCONTEXT *, char *, int, int);

   int pathlen;		/* the minimal length of each path */
   int mydist;		/* my distance from src */
   int faredge;		/* node at far end of path */
   int lastlong;	/* distance to node on end of last path with extra node */
   int rdest, cdest;    /* row and column coordinates of destination node */
   int nrnodes;         /* number of receiving nodes ( = nnodes-1 ) */
   int Ng, nprow, npcol, myrow, mycol;
   int msgid;

   Mgridinfo(ctxt, Ng, nprow, npcol, myrow, mycol);
   if (npaths == FULLCON) npaths = Ng;
   scope = Mlowcase(scope);
   switch(scope)
   {
   case 'r':
      msgid = Mrid(ctxt);
      Arecv2d00(ctxt, bp, length, msgid);
      nrnodes = npcol - 1;
      rdest = myrow;
      if (npaths > 0)
      {
         cdest = (mycol+1) % npcol;
         mydist = (npcol + mycol - csrc) % npcol;
      }
      else
      {
	 cdest = (nrnodes+mycol) % npcol;
         mydist = (npcol + csrc - mycol) % npcol;
	 npaths = -npaths;
      }
      break;
   case 'c':
      msgid = Mcid(ctxt);
      Arecv2d00(ctxt, bp, length, msgid);
      nrnodes = nprow - 1;
      if (npaths > 0)
      {
         rdest = (myrow+1) % nprow;
         mydist = (nprow + myrow - rsrc) % nprow;
      }
      else
      {
	 rdest = (nrnodes+myrow) % nprow;
         mydist = (nprow + rsrc - myrow) % nprow;
	 npaths = -npaths;
      }
      cdest = mycol;
      break;
   case 'a':  /* NOTE: faredge temp. holds src and dest in this case */
      msgid = Maid(ctxt);
      Arecv2d00(ctxt, bp, length, msgid);
      nrnodes = Ng - 1;
      faredge = Mvkpnum(ctxt, rsrc, csrc);
      if (npaths > 0)
      {
         mydist = (Ng + ctxt->vIam - faredge) % Ng;
         faredge = (ctxt->vIam+1) % Ng;
      }
      else
      {
         mydist = (Ng + faredge - ctxt->vIam) % Ng;
	 faredge = (nrnodes+ctxt->vIam) % Ng;
	 npaths = -npaths;
      }
      Mvpcoord(ctxt, faredge, rdest, cdest);
      break;
   default:
      return(BADSCP);
   }
/*
 * Make sure npaths is cool
 */
   if (npaths > nrnodes) npaths = nrnodes;

   pathlen = nrnodes / npaths;
   lastlong = (nrnodes%npaths) * (pathlen+1);
   if (lastlong)
   {
      if (mydist <= lastlong) faredge = ((mydist-1)/(pathlen+1)+1)*(pathlen+1);
      else faredge = ((lastlong-1)/(pathlen+1)+1) * (pathlen+1)
		     + ((mydist-lastlong-1)/pathlen + 1) * pathlen;
   }
   else faredge = ((mydist-1)/pathlen + 1) * pathlen;

   BuffIsFree(bp, 1);	/* wait for recv to complete */

   if (mydist < faredge) Asend2d00(ctxt, bp, length, rdest, cdest, msgid);
   return(0);
}
