#=============================================================================
#====================== SECTION 1: PATHS AND LIBRARIES =======================
#=============================================================================
#  The following macros specify the name and location of libraries required by
#  the BLACS and its tester.
#=============================================================================
 
#  -----------------------------
#  The top level BLACS directory
#  -----------------------------
   BTOPdir = $(HOME)/BLACS

#  ---------------------------------------------------------------------------
#  The communication library your BLACS have been written for.
#  Known choices (and the machines they run on) are:
#
#     COMMLIB   MACHINE
#     .......   ..............................................................
#     CMMD      Thinking Machine's CM-5
#     MPI       Wide variety of systems
#     MPL       IBM's SP series (SP1 and SP2)
#     NX        Intel's supercomputer series (iPSC2, iPSC/860, DELTA, PARAGON)
#     PVM       Most unix machines; See PVM User's Guide for details
#  ---------------------------------------------------------------------------
   COMMLIB = MPI

#  -------------------------------------------------------------
#  The platform identifier to suffix to the end of library names
#  -------------------------------------------------------------
   PLAT = T3E

#  ----------------------------------------------------------
#  Name and location of the BLACS library.  See section 2 for 
#  details on BLACS debug level (BLACSDBGLVL).
#  ----------------------------------------------------------
   BLACSdir    = $(BTOPdir)/LIB
   BLACSDBGLVL = 0
#   BLACSFINIT  = $(BLACSdir)/blacsF77init_$(COMMLIB)-$(PLAT)-$(BLACSDBGLVL).a
#   BLACSCINIT  = $(BLACSdir)/blacsCinit_$(COMMLIB)-$(PLAT)-$(BLACSDBGLVL).a
#   BLACSLIB    = $(BLACSdir)/blacs_$(COMMLIB)-$(PLAT)-$(BLACSDBGLVL).a
   BLACSLIB    = $(HOME)/lib/libmpiblacs.a

#  -------------------------------------
#  Name and location of the MPI library.
#  -------------------------------------
#   MPIdir = /opt/ctl/mpt/mpt
   MPIdir = /opt/ctl/mpt/1.2.0.0.6
   MPILIBdir = $(MPIdir)
   MPIINCdir = $(MPIdir)/include
   MPILIB = 
#
#  -------------------------------------
#  All libraries required by the tester.
#  -------------------------------------
   BTLIBS = $(BLACSFINIT) $(BLACSLIB) $(BLACSFINIT) $(MPILIB)

#  ------------------------------------------------
#  If BTINTFACE = C, we test the C interface BLACS;
#  else we test the fortran interface BLACS. 
#  ------------------------------------------------
   BTINTFACE = F

#  ----------------------------------------------------------------
#  The directory to put the installation help routines' executables
#  ----------------------------------------------------------------
   INSTdir = $(BTOPdir)/INSTALL/EXE

#  ------------------------------------------------
#  The name and location of the tester's executable
#  ------------------------------------------------
   TESTdir = $(BTOPdir)/TESTING/EXE
   FTESTexe = $(TESTdir)/xFbtest_$(COMMLIB)-$(PLAT)-$(BLACSDBGLVL)
   CTESTexe = $(TESTdir)/xCbtest_$(COMMLIB)-$(PLAT)-$(BLACSDBGLVL)
#=============================================================================
#=============================== End SECTION 1 ===============================
#=============================================================================
 

#=============================================================================
#========================= SECTION 2: BLACS INTERNALS ========================
#=============================================================================
#  The following macro definitions set preprocessor values for the BLACS.
#  The file Bconfig.h sets these values if they are not set by the makefile.
#  User's compiling only the tester can skip this entire section.
#  NOTE: The MPI defaults have been set for MPICH.
#=============================================================================

#  -----------------------------------------------------------------------
#  The directory to find the required communication library include files, 
#  if they are required by your system.
#  -----------------------------------------------------------------------
   SYSINC = -I$(MPIINCdir)

#  -------------------------------------------------------
#  The Fortran 77 to C interface to be used.  Choices are:
#  Add_, NoChange, UpCase, or f77IsF2C.
#  -------------------------------------------------------
   INTFACE = -DUpCase

#  ------------------------------------------------------------------------
#  Allows the user to vary the topologies that the BLACS default topologies
#  (TOP = ' ') correspond to.  If you wish to use a particular topology
#  (as opposed to letting the BLACS make the choice), uncomment the
#  following macros, and replace the character in single quotes with the
#  topology of your choice.
#  ------------------------------------------------------------------------
#  DEFBSTOP   = -DDefBSTop="'1'"
#  DEFCOMBTOP = -DDefCombTop="'1'"

#  -------------------------------------------------------------------
#  If your MPI_Send is locally-blocking, substitute the following line
#  for the empty macro definition below.
#   SENDIS = -DSndIsLocBlk
#  -------------------------------------------------------------------
   SENDIS = 

#  --------------------------------------------------------------------
#  If your MPI handles packing of non-contiguous messages by copying to
#  another buffer or sending extra bytes, better performance may be
#  obtained by replacing the empty macro definition below with the
#  macro definition on the following line.
#  BUFF = -DNoMpiBuff
#  --------------------------------------------------------------------
   BUFF =

#  -----------------------------------------------------------------------
#  If you know something about your system, you may make it easier for the
#  BLACS to translate between C and fortran communicators.  If the empty
#  macro defininition is left alone, this translation will cause the C
#  BLACS to globally block for MPI_COMM_WORLD on calls to BLACS_GRIDINIT
#  and BLACS_GRIDMAP.  If you choose one of the options for translating
#  the context, neither the C or fortran calls will globally block.
#  If you are using MPICH, or a derivitive system, you can replace the 
#  empty macro definition below with the following (note that if you let
#  MPICH do the translation between C and fortran, you must also indicate
#  here if your system has pointers that are longer than integers.  If so,
#  define -DPOINTER_64_BITS=1):
#  TRANSCOMM = -DUseMpich -DPOINTER_64_BITS=1
#
#  If you know that your MPI uses the same handles for fortran and C
#  communicators, you can replace the empty macro definition below with
#  the macro definition on the following line.
  TRANSCOMM = -DCSameF77
#  -----------------------------------------------------------------------
#   TRANSCOMM =

#  --------------------------------------------------------------------------
#  You may choose to have the BLACS internally call either the C or Fortran77
#  interface to MPI by varying the following macro.  If TRANSCOMM is left
#  empty, the C interface BLACS_GRIDMAP/BLACS_GRIDINIT will globally-block if
#  you choose to use the fortran internals, and the fortran interface will
#  block if you choose to use the C internals.  It is recommended that the 
#  user leave this macro definition blank, unless there is a strong reason
#  to prefer one MPI interface over the other.
#  WHATMPI = -DUseF77Mpi
#  WHATMPI = -DUseCMpi
#  --------------------------------------------------------------------------
   WHATMPI =

#  ---------------------------------------------------------------------------
#  Some early versions of MPICH and its derivatives cannot handle user defined
#  zero byte data types.  If your system does, Replace the macro definition
#  below with the empty macro definition on the following line.
  SYSERRORS =
#  ---------------------------------------------------------------------------
#   SYSERRORS = -DZeroByteTypeBug

#  ------------------------------------------------------------------
#  These macros set the debug level for the BLACS.  The fastest
#  code is produced by BlacsDebugLvl 0.  Higher levels provide
#  more debug information at the cost of performance.  Present levels
#  of debug are:
#  0 : No debug information
#  1 : Mainly parameter checking.
#  ------------------------------------------------------------------
   DEBUGLVL = -DBlacsDebugLvl=$(BLACSDBGLVL)

#  -------------------------------------------------------------------------
#  All BLACS definitions needed for compile (DEFS1 contains definitions used
#  by all BLACS versions).
#  -------------------------------------------------------------------------
   DEFS1 = -DSYSINC $(SYSINC) $(INTFACE) $(DEFBSTOP) $(DEFCOMBTOP) $(DEBUGLVL)
   BLACSDEFS = $(DEFS1) $(SENDIS) $(BUFF) $(TRANSCOMM) $(WHATMPI) \
		$(SYSERRORS) -DCRAY
#=============================================================================
#=============================== End SECTION 2 ===============================
#=============================================================================
 

#=============================================================================
#=========================== SECTION 3: COMPILERS ============================
#=============================================================================
#  The following macros specify compilers, linker/loaders, the archiver,
#  and their options.  Some of the fortran files need to be compiled with no
#  optimization.  This is the F77NO_OPTFLAG.  The usage of the remaining
#  macros should be obvious from the names.
#=============================================================================
   F77            = f90
   F77NO_OPTFLAGS = -dp -X m
   F77FLAGS       = $(F77NO_OPTFLAGS) -O3,aggress
   F77LOADER      = $(F77)
   F77LOADFLAGS   = 
   CC             = cc
   CCFLAGS        = -O3
   CCLOADER       = $(CC)
   CCLOADFLAGS    = 

#  --------------------------------------------------------------------------
#  The archiver and the flag(s) to use when building an archive (library).
#  Also the ranlib routine.  If your system has no ranlib, set RANLIB = echo.
#  --------------------------------------------------------------------------
   ARCH      = ar
   ARCHFLAGS = r
   RANLIB    = echo

#=============================================================================
#=============================== End SECTION 3 ===============================
#=============================================================================
