

PVM program:


/* check delay variation */
#include <stdio.h>
#include <pvm3.h>
/*
#include "/cray/uss/u0/par/latest/mpi/mpi.h"
*/

#define REPS 1000
#define PREC 1000000.
#define R2 20
double vec[REPS];
FILE *fp;
#define ALIGN   4096

#define hz 151500000.

main(argc,argv)
int argc;
char *argv[];
{
	double s,t,q,min,max,avrg,var,ovrhd,secs();
	char *vtmp, *malloc();
	int rlth,lth,i,j,k,me,np,tmp;
	int kmin,m,imax,imin,iavrg;
	int src,dst;
	int type=0;
        int words;
/*
        MPI_Status status;

    MPI_Init( &argc, &argv );
    MPI_Comm_rank( MPI_COMM_WORLD, &me );
    MPI_Comm_size( MPI_COMM_WORLD, &np );
*/
    me = _my_pe();
    np = _num_pes();


	lth=1000000;
	if (argc > 1) lth = atoi(argv[1]);
        words = lth/8;
	vtmp = malloc(lth + ALIGN +1);  /* page align for hot intel perf. */
/*
	vtmp = (char *)((((unsigned long)vtmp) + ALIGN-1) & ~(ALIGN-1));
*/
	for(i=0;i<lth;i++) vtmp[i]=0;  /* pre-touch and avoid VM delays */
	if (me ==0){
	   src=dst=1;
	   ovrhd = 100000000000000000000000.;   /* determine clock overhead */
	   for(i=0;i<10;i++){
		t=IRTC();
		s=IRTC();
		t= s-t;
		if (t < ovrhd) ovrhd = t;
   	    }
	   for(i=0;i<REPS;i++)vec[i]=0;  /* avoid pg faults */
	   avrg = max = 0;
	   min = 100000000000000000000000.;
                pvm_psend(dst, 100, (char *) &i, 1, PVM_INT);
                pvm_precv(src, 100, (char *) &i, 1, PVM_INT, NULL, NULL, NULL);
	   s = IRTC();
	   for(i=0;i<3;i++){ /* warmup */
                pvm_psend(dst, 100, vtmp, lth, PVM_BYTE);
                pvm_precv(src, 100, vtmp, lth, PVM_BYTE, NULL, NULL, NULL);
	   }
	   for(i=0;i<REPS;i++){
		t = IRTC();
                pvm_psend(dst, 100, vtmp, lth, PVM_BYTE);
                pvm_precv(src, 100, vtmp, lth, PVM_BYTE, NULL, NULL, NULL);
		q=IRTC();
		t = q-t-ovrhd;
		if (t < min) min=t;
		if (t > max) max=t;
		avrg += t;
		vec[i] = t;
	   }
	   t=IRTC();

           avrg = avrg/hz;
           min = min/hz;
           max = max/hz;
           ovrhd = ovrhd/hz;
           s = s/hz;
           t = t/hz;
           for (i=0;i<REPS;i++) vec[i]=vec[i]/hz;

           var=0.;
           avrg = avrg/REPS;
           for(i=0;i<REPS;i++) var += (vec[i]-avrg)*(vec[i]-avrg);
	   printf("at %f overhead %f us\n",t,ovrhd*1.e6);
	   printf("reps %d min %f max %f disp %f avrg %f var %g over %f secs\n",
	     REPS,min,max,max-min,avrg,var,t-s);
	    printf (" lth %d  %f MBs %f us 1-way avrg: %f %f\n",
	    lth, 2.e-6*lth/min,.5e6*min,2.e-6*lth/avrg,.5e6*avrg);

	   fp = fopen("v.tmp","w");
	   for (i=0;i<REPS;i++)fprintf(fp,"%d %d\n",i,(int)(10000000 * vec[i]));
	   fclose(fp);
	   printf("done on %d procs with %d byte messages\n",np,lth);
	}

	if (me== 1){
		src=dst=0;
                pvm_precv(src, 100, (char *) &i, 1, PVM_INT, NULL, NULL, NULL);
                pvm_psend(dst, 100, (char *) &i, 1, PVM_INT);
                
	   for(i=0;i<3;i++){  /* warmup */
                pvm_precv(src, 100, vtmp, lth, PVM_BYTE, NULL, NULL, NULL);
                pvm_psend(dst, 100, vtmp, lth, PVM_BYTE);
	   }
	   for(i=0;i<REPS;i++){
                pvm_precv(src, 100, vtmp, lth, PVM_BYTE, NULL, NULL, NULL);
                pvm_psend(dst, 100, vtmp, lth, PVM_BYTE);
	   }
	}
	
}

#include <sys/time.h>
double
secs()
{
        struct timeval ru;
        gettimeofday(&ru, (struct timezone *)0);
        return(ru.tv_sec + ((double)ru.tv_usec)/1000000);
}

