/****************************************************************
Copyright (C) 2000 Lucent Technologies
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of Lucent or any of its entities
not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

LUCENT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL LUCENT OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.
****************************************************************/

/* Written by David M. Gay (dmg).  Updated 2002, 2005 by dmg for */
/* AMPL Optimization LLC, which also disclaims all */
/* warranties with regard to this software. */

/* Parts of sw.c (such as font handling and WindowProc) are derived from
 * WATCOM's SAMPLES\WIN\EDIT example, which carries the following notice...
 */
/*
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *%									   %
 *%	Copyright (C) 1991,1994 by WATCOM International Inc.		   %
 *%	All rights reserved.						   %
 *%									   %
 *%     Permission is granted to anyone to use this example program for	   %
 *%     any purpose on any computer system, subject to the following	   %
 *%	restrictions:							   %
 *%									   %
 *%     1. This example is provided on an "as is" basis, without warranty. %
 *%	   You indemnify, hold harmless and defend WATCOM from and against %
 *%	   any claims or lawsuits, including attorney's, that arise or	   %
 *%	   result from the use or distribution of this example, or any     %
 *%	   modification thereof.					   %
 *%									   %
 *%     2. You may not remove, alter or suppress this notice from this	   %
 *%        example program or any modification thereof.			   %
 *%									   %
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 */
#if 0
#define Debug(x) x
#else
#define Debug(x) /*ignore*/
#endif
#include <windows.h>
#define MB_ok (MB_OK|MB_SETFOREGROUND)
typedef DWORD Seltype;
#define WANT_FONTS
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "swimpl.h"

static char about[] = "\n\nsw = Scrolling Window 1.3 (20100913)\n"
			"Copyright 2000 Lucent Technologies.\n"
			"Updated 2002, 2005 by AMPL Optimization LLC.\n"
			"This program is provided without warranty;\n"
			"use it at your own risk.\n"
			"It may be copied, freely distributed,\n"
			"and used for any purpose.\n";

#define R_SWRITE (WM_USER+64)

static char 	*SwTitle;
static char 	SwClass[32]="SwClass";

static BOOL FirstInst( HANDLE );
static BOOL AnyInst( HANDLE, LPEDATA );
static void ShutDown(LPEDATA, HWND);
long PASCAL WindowProc( HWND, unsigned, WORD, LONG );

static char anum[256];
static int afterup = 1, await_read = 1, await_write = 1, c_as_b = 1, fastswrite = 1;
static int bugfixing, control_S, dblclick, ending_proc, escml, exiting, have_exitcode;
static int ignoreclick, multiline, ncbutton, read_waiting, running;
static int swrite_waiting, tocursor, want_Sw, wholechk, write_waiting;
static long exitcode, nswrite;
static char *swbuf;
static UINT unix_point;
static UINT SW_WMAX = 480*1024, SW_WMIN = 440*1024; /* was 48 and 40 before 20100913 */
static HWND mw, mw0;
static HANDLE CanRead, CanSwrite, CanUpdate, CanWait, CanWrite, Swritten;
static HANDLE ProcRead, ProcReadEnd, ProcWrite, Sig[2];
static HHOOK hh;
Debug(static FILE *logf;)
static LPEDATA Ed;
static PROCESS_INFORMATION *curproc, procinfo;
static Seltype dcdw[2];

typedef struct HistHead {
	struct HistHead *back, *fwd, *backcmd, *fwdcmd;
	char *end;  /* string starts at h+1, ends with null at end */
	} HistHead;
#define HISTLEN 16384
static HistHead *Hist[HISTLEN];
static HistHead *const Hist0 = (HistHead*)Hist;
static HistHead *const Hist1 = (HistHead*)Hist + 1;
static HistHead *const Hist2 = (HistHead*)Hist + 2;
static HistHead *const Histend = (HistHead*)&Hist[HISTLEN];
static HistHead *Histcur, *Histnext, *Histlast = (HistHead*)&Hist[HISTLEN];

#define RBbuflen 4095
#define SIGINT 2
#define SIGTERM 15

 typedef struct
ReadBuf {
	struct ReadBuf *next;
	char *cnext;
	char *clast;
	char buf[RBbuflen+1];
	} ReadBuf;

 typedef struct
ReadQueue {
	struct ReadQueue *next;
	ReadBuf *b;	/* block allocated within this ReadBuf */
	char *s;	/* first char in this block */
	char *se;	/* block has length se - s */
	} ReadQueue;

static ReadBuf RB0[2];
static ReadBuf *RB = &RB0[0], *RBfree = &RB0[1];
#define RQGulp 20
static ReadQueue *RQ, RQ0[RQGulp], **RQlnext = &RQ, *freeRQ;

static char msgbuf[1024];
static char procname[256], *procstate;

struct { long L, L0, L1; int nbs, nsent; } Eb;

 static void swrite(char *, size_t);

 static void
Msg0(char *msg)
{ MessageBox(NULL, msg, SwTitle, MB_ok); }

 static void
Msg(char *fmt, unsigned long n)
{
	sprintf(msgbuf, fmt, n);
	Msg0(msgbuf);
	}

 static void
clear_hist(void)
{
	Hist0->fwd = Hist0->back = Hist0->fwdcmd = Hist0->backcmd = Hist0;
	Histlast = Histend;
	Histnext = Hist1;
	}

 static HistHead *
line_save(char *s, char *se)
{
	HistHead *h, *he, *hp;
	char *s1;
	size_t nh;

	Histcur = 0;
	for(;;--se) {
		if (se <= s)
			return 0;
		if (*(unsigned char*)(se-1) > ' ')
			break;
		}
	nh = se - s;
	if ((h = Hist0->back) != Hist0
	 && (h->end - (char*)(h+1)) == nh
	 && !memcmp(h+1, s, nh))
		return h;
	nh = (nh + sizeof(HistHead)) / sizeof(HistHead*) + 1;
	if ((HistHead**)Histlast - (HistHead**)Histnext < nh) {
		he = Histnext = Hist0->fwd;
		do {
			he = (h = he)->fwd;
			Histlast = he < h ? Histend : he;
			if (he == Hist0) {
				clear_hist();
				if ((HistHead**)Histend - (HistHead**)Hist1 < nh) {
					/* unlikely case: huge string; truncate */
					se = s + ((char*)Histend - (char*)Hist2) - 1;
					nh = ((se-s) + sizeof(HistHead))
						 / sizeof(HistHead*) + 1;
					break;
					}
				}
			if (hp = h->backcmd)
				(hp->fwdcmd = h->fwdcmd)->backcmd = hp;
			hp = h->back;
			(hp->fwd = h->fwd)->back = hp;
			if (h == Hist1)
				Histnext = h;
			}
			while((HistHead**)Histlast - (HistHead**)Histnext < nh);
		}
	h = Histnext;
	Histnext = (HistHead*)((HistHead**)h + nh);
	Hist0->back = (h->back = Hist0->back)->fwd = h;
	h->fwd = Hist0;
	h->fwdcmd = h->backcmd = 0;
	memcpy(s1 = (char*)(h+1), s, nh = se - s);
	*(h->end = s1 + nh) = 0;
	return h;
	}

 static void
cmd_save(char *s, char *se)
{
	HistHead *h;
	if ((h = line_save(s, se)) && !h->fwdcmd) {
		h->fwdcmd = Hist0;
		(h->backcmd = Hist0->backcmd)->fwdcmd = h;
		Hist0->backcmd = h;
		}
	}

 static void
swrite1(char *msg)
{
	char buf[64];
	size_t n;

	for(n = 0; buf[n] = msg[n]; n++);
	swrite(buf, n); /* may scribble on buf */
	}

 static void
Bailout(char *msg)
{ FatalAppExit(0,msg); }

 static void *
Malloc1(unsigned n)
{
	void *rv = malloc(n);
	if (!rv) {
		Msg("malloc(%u) failure!", n);
		exit(-1);
		}
	return rv;
	}

 static char *
name_adjust(char *name, char *buf, size_t buflen)
{
	char *dot, *s;
	int nlen;

	dot = 0;
	for(s = name; *s; s)
		switch(*s++) {
		  case '.': dot = s; break;
		  case ':':
		  case '/':
		  case '\\':
			dot = 0;
		  }
	nlen = s - name;
	if (dot || nlen + 5 > buflen)
		return name;
	strcpy(buf, name);
	strcpy(buf+nlen, ".EXE");
	return buf;
	}

 static int
gui_exe(char *name)
{
	char buf[512];
	FILE *f;
	IMAGE_DOS_HEADER dh;
	int rc;
	union { WORD w[2]; DWORD dw; } u;
	struct {
		IMAGE_FILE_HEADER ifh;
		IMAGE_OPTIONAL_HEADER ioh;
		} h;

	name = name_adjust(name, buf, sizeof(buf));

	rc = 0;
	if (!(f = fopen(name, "rb")))
		goto done1;
	if (!fread(&dh, sizeof(IMAGE_DOS_HEADER), 1, f))
		goto done;
	if (dh.e_magic != IMAGE_DOS_SIGNATURE)
		goto done;
	if (fseek(f, dh.e_lfanew, SEEK_SET)
	 || !fread(&u, sizeof(u), 1, f))
		goto done;
	if (u.dw == IMAGE_NT_SIGNATURE) {
		if (!fread(&h, sizeof(h), 1, f))
			goto done;
		switch(h.ioh.Subsystem) {
		  case IMAGE_SUBSYSTEM_UNKNOWN:
			/* Unknown NT executable */
			break;
		  case IMAGE_SUBSYSTEM_NATIVE:
			/* native Win32 executable */
			break;
		  case IMAGE_SUBSYSTEM_WINDOWS_GUI:
			rc = 1;
			break;
		  case IMAGE_SUBSYSTEM_WINDOWS_CUI:
			/* Win32 console executable */
			break;
		  case IMAGE_SUBSYSTEM_OS2_CUI:
			/* OS/2 console executable */
			break;
		  case IMAGE_SUBSYSTEM_POSIX_CUI:
			/* POSIX console executable */
			break;
		  }
		}
	else {
		switch(u.w[0]) {
		  case IMAGE_OS2_SIGNATURE:
			/* 16-bit Windows executable */
			rc = 1;
			break;
		  case IMAGE_OS2_SIGNATURE_LE:
			/* LE executable */
			break;
		  }
		}
 done:
	fclose(f);
 done1:
	return rc;
	}

#define PBLEN 8192

 static char *
Getenv(char *name, char *b)
{
	DWORD rv;

	rv = GetEnvironmentVariable(name, b, PBLEN);
	if (rv > 0 && rv < PBLEN)
		return b;
	return 0;
	}

 static int
find_cmd(char *cmd, char *pbuf, size_t pbuf_len, char **b)
{
	char *dot, pb[PBLEN], *p, *s;
	/* This uses NT's incomprehensible search rules. */
	if (SearchPath(".", cmd, ".exe", pbuf_len, pbuf, b)
	|| (p = Getenv("PATH",pb)) && SearchPath(p, cmd, ".exe", pbuf_len, pbuf, b)
	|| (p = Getenv("Path",pb)) && SearchPath(p, cmd, ".exe", pbuf_len, pbuf, b))
		return 1;
	dot = 0;
	for(s = cmd;;)
		switch(*s++) {
		  case 0:
			goto break2;
		  case '/':
		  case ':':
		  case '\\':
			dot = 0;
			break;
		  case '.':
			dot = s;
		  }
 break2:
	if (dot)
		return 0;
	if (SearchPath(".", cmd, ".com", pbuf_len, pbuf, b)
	|| p && SearchPath(p, cmd, ".com", pbuf_len, pbuf, b))
		return 1;
	if (SearchPath(".", cmd, ".bat", pbuf_len, pbuf, b)
	|| p && SearchPath(p, cmd, ".bat", pbuf_len, pbuf, b))
		return 2;
	return 0;
	}

 static int
pipe(HANDLE *fd, int inherit)
{
	SECURITY_ATTRIBUTES S;

	S.nLength = sizeof(S);
	S.lpSecurityDescriptor = 0;
	S.bInheritHandle = inherit;
	if (CreatePipe(fd,fd+1,&S,1024))
		return 1;
	Msg0("CreatePipe failed!\n");
	return 0;
	}

 static HANDLE
inheritable(HANDLE h)
{
	HANDLE h1 = h;
	HANDLE This = GetCurrentProcess();

	if (DuplicateHandle(This, h, This, &h1, 0, TRUE,
			DUPLICATE_SAME_ACCESS))
		CloseHandle(h);
	return h1;
	}

 static int
pipe_run(HANDLE *h, PROCESS_INFORMATION *Pi, char *cmd, char *args)
{
	HANDLE fd[4];
	int b, i, j, rc;
	char *base, pbuf[1024];
	STARTUPINFO Si;

	if (!find_cmd(cmd, pbuf, sizeof(pbuf), &base)) {
		i = strlen(cmd);
		if (i > sizeof(procname) - 1)
			i = sizeof(procname) - 1;
		strncpy(procname, cmd, i);
		return 1;
		}

	memset(&Si,0,sizeof(Si));
	Si.cb = sizeof(Si);
	Si.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;
	Si.wShowWindow = SW_HIDE; /* change to SW_SHOW when using MessageBox under W9x */

	rc = 0;
	if (gui_exe(pbuf)) {
		rc = 3;
		fd[0] = fd[3] = 0;
		Si.wShowWindow = SW_SHOWNORMAL;
		goto no_pipe;
		}

	if (!pipe(fd,0) || !pipe(fd+2,0))
		return 2;

	fd[0] = inheritable(fd[0]);
	fd[3] = inheritable(fd[3]);

	/* start cmd process */

 no_pipe:
	Si.hStdInput = fd[0];
	Si.hStdOutput = Si.hStdError = fd[3];
	b = CreateProcess(pbuf, args, 0, 0, 1, 0, 0, 0, &Si, Pi);

	if (rc == 3) {
		if (!b)
			goto badstart;
		CloseHandle(Pi->hProcess);
		goto done;
		}

	CloseHandle(fd[0]);

	if (!b) {
		CloseHandle(fd[1]);
		CloseHandle(fd[2]);
		CloseHandle(fd[3]);
 badstart:
		swrite(msgbuf, sprintf(msgbuf,
			"CreateProcess(\"%s\") failure!\nError code %ld.\n",
			pbuf, GetLastError()));
		return 2;
		}

	h[0] = fd[2];
	h[1] = fd[1];
	h[2] = fd[3];
 done:
	CloseHandle(Pi->hThread);
	return rc;
	}

 static ReadQueue *
new_rq(void)
{
	ReadQueue *rq;
	int i;

	if (!(rq = freeRQ)) {
		rq = Malloc1(RQGulp*sizeof(ReadQueue));
		for(i = 0; i < RQGulp; i++) {
			rq->next = freeRQ;
			freeRQ = rq++;
			}
		--rq;
		}
	freeRQ = rq->next;
	*RQlnext = rq;
	*(RQlnext = &rq->next) = 0;
	return rq;
	}

 static void
free_rq(ReadQueue *rq)
{
	ReadBuf *rb;

	if ((rb = rq->b) && rq->se == rb->clast) {
		rb->next = RBfree;
		RBfree = rb;
		}
	rq->next = freeRQ;
	freeRQ = rq;
	}

 static void
enqueue(char *s, size_t len)
{
	ReadQueue *rq;
	size_t len1;

	if (len <= 0) {
		rq = new_rq();
		rq->s = rq->se = 0;
		rq->b = 0;
		goto done;
		}
	do {
		rq = new_rq();
		if ((len1 = len) > RBbuflen)
			len1 = RBbuflen;
		if (RB->clast - RB->cnext < len1) {
			if (RB = RBfree)
				RBfree = RB->next;
			else
				RB = Malloc1(sizeof(ReadBuf));
			RB->cnext = RB->buf;
			RB->clast = RB->cnext + RBbuflen;
			}
		rq->b = RB;
		memcpy(rq->s = RB->cnext, s, len1);
		rq->se = RB->cnext += len1;
		}
		while(len -= len1);
 done:
	await_write = 0;
	if (write_waiting && !ending_proc)
		SetEvent(CanWrite);
	}

 static void
adjust_title(void)
{
	int i;

	i = control_S ? sprintf(msgbuf, "^S ") : 0;
	i = sprintf(msgbuf+i, multiline ? "multiline %s" : "%s", SwTitle);
	if (procname[0]) {
		i += sprintf(msgbuf+i, ": %s %s", procstate, procname);
		if (have_exitcode)
			sprintf(msgbuf+i, " = %ld", exitcode);
		}
	SetWindowText(mw0, msgbuf);
	}

static char *mw_bytebuf;
static long mw_bblen;

 static char *
mw_bytes(void)
{
	long L, L1;

	L = SendMessage(mw,WM_GETTEXTLENGTH,0,0L) + 1;
	if (L > mw_bblen) {
		L1 = (L + 4095) & ~4095;
		if (mw_bytebuf)
			free(mw_bytebuf);
		if (!(mw_bytebuf = malloc(L1)))
			return 0;
		mw_bblen = L1;
		}
	SendMessage(mw,WM_GETTEXT,(WPARAM)L,(LPARAM)mw_bytebuf);
	return mw_bytebuf;
	}

 static Seltype *
getsel(Seltype *dw)
{
	SendMessage(mw, EM_GETSEL, (WPARAM)dw, (LPARAM)(dw+1));
	return dw;
	}

 static void
setsel(Seltype *dw)
{
	SendMessage(mw, EM_SETSEL, (WPARAM)dw[0], (LPARAM)dw[1]);
	wholechk = 1;
	}

 static void
newsel(Seltype dw[2])
{
	if (exiting)
		return;
	getsel(dw);
	if (dw[0] < unix_point && dw[1] > unix_point) {
		if (afterup)
			dw[0] = unix_point;
		else
			dw[1] = unix_point;
		setsel(dw);
		}
	afterup = dw[0] >= unix_point;
	wholechk = 1;
	}

 static void
AllSelect( LPEDATA ed )
{
	static Seltype dw[2];
	dw[1] = unix_point;
	setsel(dw);
	newsel(dw);
	}

 static void
have_nl(int wantbytes, int canend, int eof)
{
	Seltype dw[2];
	char *s, *s0, *s1;
	size_t n;

	s = s0 = mw_bytes() + unix_point;
	s1 = 0;
	while(*s)
		if (*s++ == '\n')
			s1 = s;
	if (!wantbytes) {
		if (!s1)
			return;
		}
	else if (eof)
		s1 = s;
	else if (!s1) {
		Msg0("Edit-control bug -- text lost.\n"
			"Try manually deleting some text, or even\n"
			"Edit|All(Select), Edit|Clear");
		dw[0] = dw[1] = unix_point = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
		setsel(dw);
		afterup = 1;
		return;
		}
	unix_point += n = s1 - s0;
	if (n)
		SendMessage(mw, EM_EMPTYUNDOBUFFER, 0, 0L);
	else if (canend)
		ShutDown(Ed, mw0);
	enqueue(s0, n);
	line_save(s0, s1);
	}

 static long
shrink(size_t len)
{
	Seltype dw[2];
	UINT j, k, kl, n, nlen;
	char *s, *s0, *se;
	long L, L1;

	Eb.L0 = L = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
	if (L + len > SW_WMAX) {
		getsel(dw);
		n = L;
		if (len < SW_WMIN)
			n -= SW_WMIN - len;
 		if (n > unix_point)
 			n = unix_point;
		/* Try to avoid later confusion in have_nl() */
		s0 = mw_bytes();
		se = s0 + unix_point;
		for(s = s0 + n ; s < se && s[-1] != '\n'; s++);
		SendMessage(mw, EM_EMPTYUNDOBUFFER, 0, 0L);
		SendMessage(mw, WM_SETTEXT, 0, (LONG)s);
		L1 = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
		n = (UINT)(L - L1);
 		unix_point -= n;
 		j = k = dw[1];
 		if (k > n)
 			k -= n;
 		else
 			k = 0;
 		j = dw[0];
 		if (j > n)
 			j -= n;
 		else
 			j = 0;
#if 0
		{char mbuf[512];
		sprintf(mbuf,
			"Discarding %u bytes\n"
			"j = %d, k = %d, len = %ld\n"
			"L was %ld, now is %ld\n"
			"adjusted unix_point = %d, afterup = %d\n"
			"changing selection from (%d,%d) to (%d,%d)\n"
			"current length = %d, max = %d",
			n, j, k, len, L, L1, unix_point, afterup, dw[0],dw[1],j,k,
			L1, SendMessage(mw,EM_GETLIMITTEXT,0,0L));
 		Msg0(mbuf);
		}
#endif
		dw[0] = j;
		dw[1] = k;
		setsel(dw);
		L = L1;
		}
	return L;
	}

 static void
showfast(HWND hwnd, int fast, int ml)
{
	HMENU h;
	static int state[2] = { MF_UNCHECKED, MF_CHECKED };

	if (h = GetMenu(hwnd)) {
		CheckMenuItem(h, MENU_FAST, state[fast]);
		CheckMenuItem(h, MENU_SLOW, state[1-fast]);
		CheckMenuItem(h, MENU_ELK, state[1-ml]);
		CheckMenuItem(h, MENU_EML, state[ml]);
		CheckMenuItem(h, MENU_SENDALL, state[1-tocursor]);
		CheckMenuItem(h, MENU_TOCURSOR, state[tocursor]);
		CheckMenuItem(h, MENU_C_AS_B, state[c_as_b]);
		CheckMenuItem(h, MENU_NO_C_AS_B, state[1-c_as_b]);
		}
	}

 static void
swrite(char *gs, size_t len)
{
	HWND w;
	UINT j, k;
	Seltype dw[2], dw1[2];
	int c, i, n, nbs;
	long L, L1;
	char buf[4128], *s, *s0;

	WaitForSingleObject(CanSwrite,INFINITE);
	SendMessage(mw, EM_EMPTYUNDOBUFFER, 0, 0L);
	c = i = n = 0;
	for(j = 0; j < len; j++, c++)
		if ((k = gs[j]) >= ' ')
			buf[i++] = k;
		else {
			switch(k) {
			 case '\t':
				buf[i++] = k;
				break;
			 case '\b':
				if (i > 0) {
					if (buf[--i] == '\n')
						--i;
					}
				else if (n + c <= 0)
					++n;
				c -= 2;
				break;
			 case '\n':
				buf[i++] = '\r';
				buf[i++] = '\n';
			 /* ignore everything else */
			 }
			}
	L = shrink(i);
	getsel(dw);
	dw1[0] = dw1[1] = unix_point;
	setsel(dw1);
	if (nbs = n) {
		if (n > unix_point)
			n = nbs = unix_point;
		while(--n >= 0)
			SendMessage(mw, WM_CHAR, '\b', 0L);
		L1 = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
		j = L - L1;
		L = L1;
		unix_point -= j;
		if (afterup) {
			dw[0] -= j;
			dw[1] -= j;
			}
		else if (dw[1] > unix_point) {
			dw[1] = unix_point;
			if (dw[0] > unix_point)
				dw[0] = unix_point;
			}
		}
	L1 = L + i;
	if (fastswrite) {
		if (i > 0) {
			buf[i] = 0;
			SendMessage(mw, EM_REPLACESEL, 0, (LPARAM)buf);
			}
		}
	else
		for(c = 0; c < i; c++)
			if ((k = buf[c]) != '\r')
				SendMessage(mw, WM_CHAR, k, 0L);
	L = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
	c = IDYES;
	if (L != L1) {
		if (L > L1 || (n = i - (L1 - L)) < -nbs) {
			sprintf(buf, "Edit-control bug mystery:\n"
				"L = %d, L1 = %d, n = %d", L, L1, n);
			Msg0(buf);
			ShutDown(Ed, Ed->hwnd);
			}
		if (n < 0)
			goto dont_worry; /* confusion from backspaces? */
		Eb.L = L;
		Eb.L1 = L1;
		Eb.nbs = nbs;
		Eb.nsent = i;
		c = MessageBox(NULL, "Edit-control bug bit;\n"
			"switching to slow mode.\n"
			"Retain old text?", "sw Edit-control bug",
			MB_YESNO | MB_SETFOREGROUND);
		Eb.L1 = 0;
		if (c == IDYES) {
			s0 = mw_bytes();
			s = s0 + L;
			while(n < i)
				*s++ = buf[n++];
			*s = 0;
			}
		else {
			s0 = buf;
			dw[0] = dw[1] = unix_point = i;
			}
		SendMessage(mw, EM_EMPTYUNDOBUFFER, 0, 0L);
		bugfixing = 1;
		if (!DestroyWindow(Ed->hwnd)) {
			Msg("DestroyWindow failure: error = %d",
				GetLastError());
			exit(-1);
			}
		if (!AnyInst(Ed->inst, Ed))
			exit(-1);
		for(s = s0; k = *s; s++)
			if (k != '\r')
				SendMessage(mw, WM_CHAR, k, 0L);
		showfast(Ed->hwnd, bugfixing = fastswrite = 0, escml);
		}
 dont_worry:
	if (c == IDYES) {
		getsel(dw1);
		n = (int)dw1[0] - (int)unix_point;
		unix_point = dw1[0];
		if (afterup || n < 0 && dw[1] >= unix_point) {
			dw[0] += n;
			dw[1] += n;
			}
		}
	SendMessage(mw, EM_EMPTYUNDOBUFFER, 0, 0L);
	setsel(dw);
	SetEvent(CanSwrite);
	}

 static void
control_U(void)
{
	char *s, *s0, *s1;
	UINT u, u1;
	Seltype dw[2];

	getsel(dw);
 	if (s0 = s1 = mw_bytes()) {
 	 	s = s0 + dw[0];
		if (afterup)
			s1 += unix_point;
		if (s > s1 && s[-1] == '\n') {
			--s;
			if (s > s1 && s[-1] == '\r')
				--s;
			}
		else
			while(s > s1 && s[-1] != '\n')
				--s;
		u = s - s0;
 	 	u1 = dw[1];
		if (u < u1) {
			dw[0] = u;
			dw[1] = u1;
			setsel(dw);
			SendMessage(mw, WM_CLEAR, 0, 0);
			if (!afterup)
				unix_point -= u1 - u;
			}
 		}
	}

 static void
anum_init(void)
{
	int i;
	for(i = '0'; i <= '9'; i++)
		anum[i] = 1;
	for(i = 'A'; i <= 'Z'; i++)
		anum[i] = anum[i+'a'-'A'] = 1;
	anum['_'] = 1;
	for(i = 128; i <= 255; i++)
		anum[i] = 1;
	}

 static void
control_W(void)
{
	Seltype dw[2];
	unsigned char *s, *s0, *s1;
	int i;

	if (!anum['1'])
		anum_init();
	getsel(dw);
	if ((dw[0] | dw[1]) && (s = (unsigned char *)mw_bytes())) {
		s0 = s1 = s;
		if (afterup)
			s1 += unix_point;
		s += dw[0];
		while(s > s1)
			if (anum[*--s]) {
				while(s > s1 && anum[s[-1]])
					--s;
				break;
				}
		dw[0] = s - s0;
		setsel(dw);
		SendMessage(mw, WM_CUT, 0, 0L);
		if (!afterup)
			unix_point -= dw[1] - dw[0];
		}
	}

 static void
worry(MSG *mp)
{
	Seltype dw[2];

	switch(mp->wParam) {
		case '\b':
			getsel(dw);
			if (dw[0] == dw[1] && dw[1] <= unix_point)
				return;
			break;
		case '\r':
		case '\n':
			if (multiline)
				break;
			DispatchMessage(mp);
			have_nl(1,0,0);
			return;
		case 4: /* ^D */
		case 26:/* ^Z */
			have_nl(1, !curproc && !RQ, 1);
			return;
		case 27: /* Esc */
			if (escml) {
				multiline ^= 1;
				adjust_title();
				if (!multiline)
					have_nl(0,0,0);
				}
			else
				control_U();
			return;
		}
	DispatchMessage(mp);
	}

 static void
up_adjust(int bs, MSG *msg)
{
	UINT i;
	Seltype dw[2];
	long L;

	if (!bs)
		getsel(dw);
	L = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
	DispatchMessage(msg);
	i = L - SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
	if (unix_point <= i) {
		unix_point = 0;
		afterup = 1;
		}
	else {
		unix_point -= i;
		if (!bs && unix_point <= (UINT)dw[0])
			afterup = 1;
		}
	}

 static void
waiter(void *arg)
{
	DWORD n, rc;
	Seltype dw[2];

	for(;;) {
		WaitForSingleObject(CanWait,INFINITE);
		if (exiting)
			return;
		WaitForSingleObject(curproc->hProcess,INFINITE);
		if (!GetExitCodeProcess(curproc->hProcess, &rc))
			rc = -1;
		else if (rc == STILL_ACTIVE)
			rc = -2;
		WaitForSingleObject(CanUpdate,INFINITE);
		procstate = "finishing";
		running = 0;
		adjust_title();
		if (ProcWrite) {
			CloseHandle(ProcWrite);
			ProcWrite = 0;
			}
		ResetEvent(Swritten);
		want_Sw = 1;
		WriteFile(ProcReadEnd, "\032", 1, &n, 0);
		SetEvent(CanUpdate);
		WaitForSingleObject(Swritten, INFINITE);
		WaitForSingleObject(CanUpdate,INFINITE);
		if (want_Sw) {
			want_Sw = 0;
			swrite1("\nUnexpected \"Swritten\" failure!\n");
			await_read = 1;
			}
		CloseHandle(curproc->hProcess);
		curproc = 0;
		exitcode = rc;
		have_exitcode = ending_proc = 1;
		procstate = "finished";
		running = 0;
		adjust_title();
		if (ProcRead) {
			CloseHandle(ProcRead);
			ProcRead = 0;
			}
		CloseHandle(ProcReadEnd);
		ending_proc = 0;
		if (RQ)
			SetEvent(CanWrite);
		swrite("sw: ", 4);
		unix_point = dw[0] = dw[1] = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
		afterup = 1;
		setsel(dw);
		SetEvent(CanUpdate);
		}
	}

 static void
reader(void *arg)
{
	DWORD rc;
	HANDLE pr;
	char buf[1024];
	int eof;
	long nw;

	for(;;) {
		if (await_read) {
			WaitForSingleObject(CanUpdate,INFINITE);
			read_waiting = 1;
			SetEvent(CanUpdate);
			WaitForSingleObject(CanRead,INFINITE);
			WaitForSingleObject(CanUpdate,INFINITE);
			read_waiting = 0;
			SetEvent(CanUpdate);
			}
		if (exiting)
			return;
		if (pr = ProcRead) {
			if (ReadFile(ProcRead, buf, sizeof(buf), &nw, 0)) {
				eof = 0;
				if (want_Sw && buf[nw-1] == '\032') {
					if (!--nw)
						goto ended;
					eof = 1;
					}
				Debug(else fprintf(logf,"%ld bytes:%.*s\n", nw,(int)nw,buf);)
				nswrite = nw;
				swbuf = buf;
				swrite_waiting = 1;
				PostMessage(mw0, R_SWRITE, 0, 0);
				WaitForSingleObject(CanRead,INFINITE);
				if (eof) {
 ended:
					want_Sw = 0;
					WaitForSingleObject(CanUpdate,INFINITE);
					await_read = 1;
					SetEvent(CanUpdate);
					SetEvent(Swritten);
					continue;
					}
				continue;
				}
			}
		WaitForSingleObject(CanUpdate,INFINITE);
		await_read = 1;
		swrite1("\nUnexpected ReadFile failure!\n");
		if (ProcWrite) {
			CloseHandle(ProcWrite);
			ProcWrite = 0;
			}
		if (ProcRead) {
			CloseHandle(ProcRead);
			ProcRead = 0;
			}
		SetEvent(CanUpdate);
		}
	}

 static void
swstart(char *s, char *se)
{
	HANDLE h[3];
	char *a, *cmd, *s0, *se0 = se;
	size_t len;
	int i, sesave = *se0;	/* so we can always set *se = 0 */
	static char *procfate[] =
		{ "running", "cannot find", "cannot start", "launched" };

	while(s < se && *s <= ' ')
		s++;
	while(se > s && se[-1] <= ' ')
		--se;
	if (s >= se)
		goto done;
	*se = 0;
	s0 = s;
	cmd_save(s, se);
	len = 0;
	if (*s == '"') {
		len = 1;
		for(a = ++s;; a++) {
			if (a >= se) {
				procstate = "Missing \" in";
				len = se - --s;
				if (len > sizeof(procname) - 1)
					len = sizeof(procname) - 1;
				sprintf(procname, "%.*s", (int)len, s);
				adjust_title();
				goto done;
				}
			if (*a == '"')
				break;
			}
		}
	else
		for(a = s + 1; a < se && *a > ' '; a++);
	if ((len += a - s0) > sizeof(procname) - 1)
		len = sizeof(procname) - 1;
	strncpy(procname, s0, len);
	procname[len] = 0;
	len = a - s;
	cmd = len < sizeof(msgbuf) ? msgbuf : Malloc1(len+1);
	memcpy(cmd, s, len);
	cmd[len] = 0;
	have_exitcode = 0;
	procstate = procfate[i = pipe_run(h, &procinfo, cmd, s0)];
	running = i == 0;
	adjust_title();
	if (i == 0) {
		curproc = &procinfo;
		ProcRead = h[0];
		ProcWrite = h[1];
		ProcReadEnd = h[2];
		await_read = await_write = 0;
		if (read_waiting)
			SetEvent(CanRead);
		if (write_waiting)
			SetEvent(CanWrite);
		SetEvent(CanWait);
		}
	else {
 done:
		if (!RQ)
			swrite("sw: ", 4);
		}
	*se0 = sesave;
	}

 static void
writer(void *arg)
{
	HANDLE pr;
	ReadQueue *rq;
	int i;
	long nw;
	size_t len;

	WaitForSingleObject(CanUpdate,INFINITE);
	for(;;) {
		if (await_write) {
			write_waiting = 1;
			SetEvent(CanUpdate);
			WaitForSingleObject(CanWrite,INFINITE);
			WaitForSingleObject(CanUpdate,INFINITE);
			write_waiting = write_waiting = 0;
			}
		if (exiting) {
			SetEvent(CanUpdate);
			return;
			}
		if (!(rq = RQ)) {
			await_write = 1;
			continue;
			}
		if (!(RQ = rq->next))
			RQlnext = &RQ;
		len = rq->se - rq->s;
		if (pr = ProcWrite) {
			if (!len) {
				CloseHandle(pr);
				ProcWrite = 0;
				free_rq(rq);
				continue;
				}
			SetEvent(CanUpdate);
			i = WriteFile(pr, rq->s, len, &nw, 0);
			WaitForSingleObject(CanUpdate,INFINITE);
			if (i) {
				free_rq(rq);
				continue;
				}
			if (ProcWrite) {
				CloseHandle(ProcWrite);
				ProcWrite = 0;
				}
			}
		if (curproc) {
			await_write = 1;	/* wait for current proc to finish */
			if (!RQ)
				RQlnext = &rq->next;
			RQ = rq;
			continue;
			}
		if (len)
			swstart(rq->s, rq->se);
		free_rq(rq);
		}
	}

 static int
sigsend(int sig, int target)
{
	DWORD n;
	int sigs[3];

	if (curproc) {
		sigs[0] = sig;
		sigs[1] = target;
		sigs[2] = 0;
		WriteFile(Sig[1], sigs, 3*sizeof(int), &n, 0);
		Sleep(50);
		ReadFile(Sig[0], sigs, sizeof(sigs), &n, 0);
		if (sigs[2])
			return 1;
		}
	return 0;
	}

 static void
kill(void)
{
	DWORD rc;

	if (curproc
	 && GetExitCodeProcess(curproc->hProcess, &rc)
	 && rc == STILL_ACTIVE) {
		rc = 400;
		WaitForSingleObject(CanUpdate,INFINITE);
		if (ProcWrite) {
			CloseHandle(ProcWrite);
			ProcWrite = 0;
			}
		SetEvent(CanUpdate);
		Sleep(200);
		if (!curproc)
			return;
		if (sigsend(SIGINT, -1)) {
			Sleep(rc = 200);
			if (!curproc)
				return;
			}
		sigsend(SIGTERM, -1);
		Sleep(rc);
		if (curproc
		 && GetExitCodeProcess(curproc->hProcess, &rc)
		 && rc == STILL_ACTIVE)
			TerminateProcess(curproc->hProcess, 0);
		}
	}

 static void
upcheck(Seltype *dw)
{
	if (dw[1] <= unix_point) {
		unix_point -= dw[1] - dw[0];
		afterup = unix_point == 0;
		}
	else
		afterup = 1;
	SetEvent(CanUpdate);
	}

 static void
copy(void)
{
	WaitForSingleObject(CanUpdate,INFINITE);
	SendMessage( mw, WM_COPY, 0, 0L );
	SetEvent(CanUpdate);
	}

 static void
cut(void)
{
	Seltype dw[2];

	WaitForSingleObject(CanUpdate,INFINITE);
	getsel(dw);
	SendMessage( mw, WM_CUT, 0, 0L );
	upcheck(dw);
	}

 static size_t
Clipbdlen(int *neednlp)
{
	char *s, *s0;

	s = s0 = 0;
	if (neednlp)
		*neednlp = 1;
	if (OpenClipboard(mw)) {
		if (s = s0 = GetClipboardData(CF_TEXT)) {
			while(*s)
				s++;
			if (neednlp && s > s0)
				switch(s[-1]) {
				  case '\n':
				  case '\r':
					*neednlp = 0;
				  }
			}
		CloseClipboard();
		}
	return s - s0;
	}

 static void
paste(void)
{
	Seltype dw[2];
	long L;

	WaitForSingleObject(CanUpdate,INFINITE);
	L = shrink(Clipbdlen(0));
	if (!afterup)
		getsel(dw);
	SendMessage( mw, WM_PASTE, 0, 0L );
	if (!afterup)
		unix_point += dw[0] - dw[1]
			+ SendMessage(mw,WM_GETTEXTLENGTH,0,0L) - L;
	SetEvent(CanUpdate);
	}

 static void
dblclick_select(void)
{
	Seltype dw[2];
	unsigned char *s, *s0, *s00, *s1, *s2, *sc, *se;
	int c, k, m, q1, q2;
	static char ctype[256] =
		/*	1 = <({[
			2 = ]})>
			3 = '"
			4 = alphanumeric */
		"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
		"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
		"\0\0\03\0\0\0\0\03\01\02\0\0\0\0\0\0"
		"\04\04\04\04\04\04\04\04\04\04\0\0\01\0\02\0"
		"\0\04\04\04\04\04\04\04\04\04\04\04\04\04\04\04"
		"\04\04\04\04\04\04\04\04\04\04\04\01\0\02\0\04"
		"\03\04\04\04\04\04\04\04\04\04\04\04\04\04\04\04"
		"\04\04\04\04\04\04\04\04\04\04\04\01\0\02\0\0";

	dblclick = 1;

	getsel(dw);
	s0 = s00 = (unsigned char *)mw_bytes();
	sc = s0 + dw[0];
	if (dw[0] < unix_point)
		se = s0 + unix_point;
	else
		for(se = s0 += unix_point; *se; se++);
	s1 = s2 = 0;
	s = sc - 1;
	q1 = q2 = 0;
	if (sc == s0)
		goto at_sol;
	switch(ctype[c = *s]) {
	  case 1:
		switch(c) {
		  case '<': m =  '>'; break;
		  case '(': m =  ')'; break;
		  case '[': m =  ']'; break;
		  case '{': m =  '}';
		  }
		goto have_m;
	  case 3:
		m = q2 = c;
 have_m:
		k = 1;
		while(++s < se)
			if (*s == m) {
				if (!--k) {
					s2 = s;
					if (*sc == '\r')
						goto use_s2;
					goto have_s2;
					}
				}
			else if (*s == c)
				k++;
	  }
	if (c == '\n') {
 at_sol:
		while(++s < se && *s != '\r');
		s2 = s;
		}
 have_s2:
	s = sc;
	if (s >= se)
		goto at_eol;
	switch(ctype[c = *s]) {
	  case 2:
		switch(c) {
		  case '>': m = '<'; break;
		  case ')': m = '('; break;
		  case ']': m = '['; break;
		  case '}': m = '{';
		  }
		goto have_m1;
	  case 3:
		m = q1 = c;
 have_m1:
		k = 1;
		while(--s >= s0)
			if (*s == m) {
				if (!--k) {
					s1 = s;
					goto have_s1;
					}
				}
			else if (*s == c)
				k++;
	  }
	if ((c = *s) == '\r' || c == '\n') {
 at_eol:
		s1 = s0 - 1;
		while(--s >= s0)
			if (*s == '\n') {
				s1 = s;
				break;
				}
		}
	if (s1)
 have_s1:
		s1++;
	if (q1 && s2 && !q2)
		s1 = 0;
	else if (q2 && s1 && !q1)
		s2 = 0;
	if (!s1 && !s2) {
		if (sc < se && ctype[*sc] == 4) {
			s1 = s2 = sc;
			for(s = sc; s < se && ctype[*s] == 4; s2 = ++s);
			}
		if (sc > s0 && ctype[*(s = sc - 1)] == 4) {
			s1 = s;
			if (!s2)
				s2 = sc;
			while(--s >= s0 && ctype[*s] == 4)
				s1 = s;
			}
		if (s1) {
			dcdw[0] = s1 - s00;
			dcdw[1] = s2 - s00;
			return;
			}
		goto no_select;
		}
	if (s1) {
		if (s2 && s2 - s < s - s1)
			goto use_s2;
		dcdw[0] = s1 - s00;
		dcdw[1] = sc - s00;
		return;
		}
	if (s2) {
 use_s2:
		dcdw[0] = sc - s00;
		dcdw[1] = s2 - s00;
		return;
		}
 no_select:
	dcdw[0] = dw[0];
	dcdw[1] = dw[1];
	}

 static void
menuadjust(HMENU h, int wantkill)
{
	Seltype dw[2];
	int state = MF_GRAYED;
	if( OpenClipboard( mw ) ) {
		if( IsClipboardFormatAvailable( CF_TEXT ) ||
			IsClipboardFormatAvailable( CF_OEMTEXT )) {
			state = MF_ENABLED;
			}
		CloseClipboard();
		}
	EnableMenuItem( h, MENU_PASTE, state );
	EnableMenuItem( h, MENU_CLEARCLIPBD, state );

	state = MF_GRAYED;
	if( SendMessage( mw, EM_CANUNDO, 0, 0L ) ) {
		state = MF_ENABLED;
		}
	EnableMenuItem( h, MENU_UNDO, state );
	getsel(dw);

	state = MF_GRAYED;
	if( dw[0] != dw[1] )
		state = MF_ENABLED;
	EnableMenuItem( h, MENU_CLEAR, state );
	EnableMenuItem( h, MENU_COPY, state );
	EnableMenuItem( h, MENU_CUT, state );
	if (wantkill) {
		state = curproc ? MF_ENABLED : MF_GRAYED;
		EnableMenuItem( h, MENU_KILL, state);
		EnableMenuItem( h, MENU_SIGINT, state);
		}
	}

 static void
GetSwTitle(void)
{
	char *s0, *s;
	int q;
	size_t i, n;

	s = GetCommandLine();
	q = 0;
	if (*s == '"') {
		q = '"';
		s++;
		}
	for(s0 = s;; s++)
		switch(*s) {
		  case '/':
		  case '\\':
		  case ':':
			s0 = s + 1;
			break;
		  default:
			if (*s == q || *s <= ' ')
				goto break2;
		  }
 break2:
	if (!(n = s - s0)) {
 use_sw:
		SwTitle = "sw";
		return;
		}
	for(i = n; i > 0; )
		if (s0[--i] == '.') {
			n = i;
			break;
			}
	if (n == 2 && !strncmp(s0,"SW",2))
		goto use_sw;
	strncpy(SwTitle = Malloc1(n+1), s0, n);
	SwTitle[n] = 0;
	}

 static void
Usage(void)
{
	HANDLE h;
	OFSTRUCT of;
	char buf0[2064], *buf;
	size_t buflen;
	long n;

	n = sprintf(buf0, "Could not open ");
	buf = buf0 + n;
	buflen = sizeof(buf0) - n;
	n = GetModuleFileName(NULL, buf, buflen);
	if (!n || n >= buflen) {
		Msg0("GetModuleFileName failure!");
		return;
		}
	for(;;) {
		if (--n <= 0) {
			Msg0("Bug in usage()");
			return;
			}
		if (buf[n] == '\\')
			break;
		}
	if (++n + 9 > buflen) {
		Msg0("ModuleFileName too long");
		return;
		}
	strcpy(buf+n, "readme.sw");
	if (GetFileAttributes(buf) == -1
	 || !(h = CreateFile(buf, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL))) {
 badfile:
		Msg0(buf0);
		return;
		}
	while(ReadFile(h, buf0, 2048, &n, 0) && n > 0)
		swrite(buf0, n);
	CloseHandle(h);
	if (!curproc)
		swrite("\nsw: ", 5);
	}

 static void
About(void)
{
	char buf[sizeof(about)];
	memcpy(buf, about, sizeof(about));
	swrite(buf, sizeof(about)-1);
	if (!curproc)
		swrite("\nsw: ", 5);
	}

 static LRESULT CALLBACK
CBTProc(int n, WPARAM w, LPARAM L)
{
	if (n == HCBT_ACTIVATE) {
		if (ncbutton)
			ignoreclick = ncbutton = 0;
		else /*if ((HWND)w == mw || (HWND)w == mw0)*/ {
			Debug(fprintf(logf, "HCBT_ACTIVATE: fMouse = %d, ignoreclick = %d\n",
				((CBTACTIVATESTRUCT*)L)->fMouse, ignoreclick);)
			ignoreclick = ((CBTACTIVATESTRUCT*)L)->fMouse ? 1 : 0;
			}
		}
	return CallNextHookEx(hh, n, w, L);
	}

 static void
arrow_leftright(int right, Seltype *dw)
{
	unsigned char *s0, *s, *se;
	if (!anum['1'])
		anum_init();
	s0 = (unsigned char*)mw_bytes();
	se = s0 + unix_point;
	if (right) {
		s = s0 + dw[1];
		while(anum[*s])
			s++;
		while(*s && !anum[*s])
			s++;
		if (!afterup && s >= se && se > s0) {
			s = se-1;
			if (s > s0 && *s == '\n')
				--s;
			}
		}
	else {
		s = s0 + dw[0];
		if (!afterup)
			se = s0;
		while(s > se && anum[s[-1]])
			--s;
		while(s > se && !anum[s[-1]])
			--s;
		}
	dw[0] = dw[1] = s - s0;
	setsel(dw);
	}

 static void
arrow_updown(int dir, Seltype *dw)
{
	HistHead *h;
	char *s0, *s1, *s;

	s0 = mw_bytes();
	s = s1 = s0 + unix_point;
	while(*s)
		s++;
	dw[0] = s1 - s0;
	dw[1] = s - s0;
	setsel(dw);
	if (s > s1)
		SendMessage(mw, WM_CUT, 0, 0L);
	if (!(h = Histcur)) {
		if (dir & 1)
			return;
		Histcur = h = Hist0;
		}
	else if (h == Hist0 && !(dir & 1))
		return;
	if (!(h = ((HistHead**)h)[dir])) {
		/*must be at an intermediate line and looking for a command */
		dir &= ~2;
		h = Histcur;
		do h = ((HistHead**)h)[dir];
			while(h != Hist0 && !h->fwdcmd);
		}
	if ((Histcur = h) == Hist0) {
		if (dir & 1)
			Histcur = 0;
		return;
		}
	SendMessage(mw, EM_REPLACESEL, 0, (LPARAM)(Histcur+1));
	wholechk = 0;
	}

#ifdef DEBUG
 static void
debug(char *cmdline)
{
	char buf[256], *b = buf, *be = buf + sizeof(buf) - 4, *s, *s0, *se;
	static char hex[] = "0123456789ABCDEF";
	int c;
	*b++ = '"';
	while(b < be && (c = *cmdline++))
		if (c >= ' ' && c <= 0x7f)
			*b++ = c;
		else {
			*b++ = '\\';
			*b++ = 'x';
			*b++ = hex[(c>>4)&0xf];
			*b++ = hex[c&0xf];
			}
	*b++ = '"';
	*b++ = '\n';
	*b = 0;
	swrite(buf, b-buf);
	s = s0 = se = GetEnvironmentStrings();
	while(*s) {
		b = buf;
		for(se = s; *b = *se++;)
			if (b < be)
				b++;
		*b++ = '\n';
		swrite(buf, b-buf);
		s = se;
		}
	FreeEnvironmentStrings(s0);
	}
#else
#define debug(x)
#endif

 int PASCAL
WinMain(HINSTANCE inst, HINSTANCE previnst, LPSTR cmdline, int cmdshow)
{
	MSG msg;
	UINT msgno;
	HANDLE h;
	HMENU hrmenu;
	Seltype dw[2];
	char *s;
	int ControlKey, dir, i;
	long L[2];
	void (*arrowkey)(int,Seltype*);

	clear_hist();
	Debug(logf = fopen("sw.log", "wb");)
	GetSwTitle();
	previnst = previnst;	/* shut up warning */
	for(i = 0; i < RQGulp; i++) {
		RQ0[i].next = freeRQ;
		freeRQ = RQ0 + i;
		};
	RB->cnext = RB->buf;
	RB->clast = RB->buf + RBbuflen;
	FirstInst( inst );
	if(!AnyInst(inst, 0)) {
		Msg0("AnyInst = 0");
		return( FALSE );
	    	}
	if (hrmenu = CreatePopupMenu()) {
		AppendMenu(hrmenu, MF_ENABLED | MF_STRING, MENU_SEND, "Send");
		AppendMenu(hrmenu, MF_ENABLED | MF_STRING, MENU_CUT, "Cut");
		AppendMenu(hrmenu, MF_ENABLED | MF_STRING, MENU_PASTE, "Paste");
		AppendMenu(hrmenu, MF_ENABLED | MF_STRING, MENU_COPY, "Copy");
		AppendMenu(hrmenu, MF_ENABLED | MF_STRING, MENU_CLEAR, "Clear");
		AppendMenu(hrmenu, MF_ENABLED | MF_STRING, MENU_UNDO, "Undo");
		AppendMenu(hrmenu, MF_ENABLED | MF_STRING, MENU_CANCEL, "Ignore");
		}
	if (!(CanUpdate = CreateEvent(NULL, FALSE, TRUE,  NULL))
	 || !(CanRead   = CreateEvent(NULL, FALSE, FALSE, NULL))
	 || !(CanSwrite = CreateEvent(NULL, FALSE, TRUE,  NULL))
	 || !(CanWrite  = CreateEvent(NULL, FALSE, FALSE, NULL))
	 || !(CanWait   = CreateEvent(NULL, FALSE, FALSE, NULL))
	 || !(Swritten  = CreateEvent(NULL, FALSE, FALSE, NULL))) {
		Msg0("CreateEvent failure!");
		goto done;
		}
	_beginthread(reader, 0, 0);
	_beginthread(writer, 0, 0);
	h = (HANDLE)_beginthread(waiter, 0, 0);
	SetThreadPriority(h, THREAD_PRIORITY_LOWEST);
	pipe(Sig,1);
	sprintf(msgbuf, "%ld,%ld,7", Sig[0], Sig[1]);
	SetEnvironmentVariable("SW_sigpipe", msgbuf);
	debug(cmdline);
	if (*cmdline) {
		Sleep(100);
		enqueue(cmdline, strlen(cmdline));
		}
	else
		swrite("sw: ", 4);
	hh = SetWindowsHookEx(WH_CBT, CBTProc, NULL, GetCurrentThreadId());
	ControlKey = 0;
    while( GetMessage( &msg, NULL, 0, 0 ) ) {

	if (msg.message == WM_KEYDOWN)
		switch(msg.wParam) {
		  case '\r':
		  case '\n':
			if (wholechk && afterup && !tocursor && !escml) {
				s = mw_bytes() + unix_point;
				i = strlen(s) + unix_point;
				dw[0] = dw[1] = i;
				setsel(dw);
				wholechk = 0;
				}
			break;
		  case VK_LEFT: /* 0x25 */
			if (!ControlKey)
				break;
			arrowkey = arrow_leftright;
			dir = 0;
			goto VK_key;
		  case VK_UP: /* 0x26 */
			if (!afterup)
				break;
			arrowkey = arrow_updown;
			dir = ControlKey ^ running ? 0 : 2;
			goto VK_key;
		  case VK_RIGHT: /* 0x27 */
			if (!ControlKey)
				break;
			arrowkey = arrow_leftright;
			dir = 1;
			goto VK_key;
		  case VK_DOWN: /* 0x28 */
			if (!afterup)
				break;
			arrowkey = arrow_updown;
			dir = ControlKey ^ running ? 1: 3;
 VK_key:
			newsel(dw);
			(*arrowkey)(dir, dw);
			continue;
		  }

	TranslateMessage( &msg );
	Debug(fprintf(logf, "%x\t%x\t%x\n", msg.message, msg.wParam, msg.lParam);)
	if (msg.message == WM_KEYDOWN) {
		switch(msg.wParam) {
		  case 3:
			sigsend(SIGINT, 0);
			break;
		  case VK_CONTROL:	/*0x11*/
			ControlKey = 1;
			break;
		  case VK_PRIOR:	/*0x21*/
		  case VK_NEXT:		/*0x22*/
		  case VK_END:		/*0x23*/
		  case VK_HOME:		/*0x24*/
		  case VK_LEFT:		/*0x25*/
		  case VK_UP:		/*0x26*/
		  case VK_RIGHT:	/*0x27*/
		  case VK_DOWN:		/*0x28*/
		  case VK_SELECT:	/*0x29*/
			newsel(dw);
			break;
		  case VK_DELETE:	/*0x2e = DEL */
			if (!afterup) {
				up_adjust(0, &msg);
				continue;
				}
			break;
		  }
		DispatchMessage(&msg);
		}

	else if ((msgno = msg.message) == WM_CHAR) {
		switch(msg.wParam) {
		  case 2: /* control-B */
			sigsend(SIGINT, 0);
			break;
		  case 3: /* control-C */
			getsel(dw);
			if (dw[0] < dw[1])
				copy();
			else if (c_as_b)
				sigsend(SIGINT, 0);
			break;
		  case 11: /* control-K */
			if (curproc)
				kill();
			break;
		  case 17: /* control-Q: accept writes */
			if (control_S) {
				WaitForSingleObject(CanUpdate,INFINITE);
				if (swrite_waiting == 2)
					swrite_waiting = 1;
				control_S = 0;
				adjust_title();
				SetEvent(CanUpdate);
				}
			break;
		  case 19: /* control-S: defer writes */
			if (!control_S) {
				WaitForSingleObject(CanUpdate,INFINITE);
				control_S = 1;
				adjust_title();
				SetEvent(CanUpdate);
				}
			break;
		  case 21: /* control-U: line kill */
			control_U();
			break;

		  case 22: /* control-V */
			paste();
			break;

		  case 23: /* control-W: delete previous word */
			control_W();
			break;

		  case 24: /* control-X */
			cut();
			break;
		  default:
			if (afterup)
				worry(&msg);
			else if (msg.wParam == '\b')
				up_adjust(1, &msg);
			else {
				L[0] = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
				DispatchMessage(&msg);
				L[1] = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
				unix_point += L[1] - L[0];
				}
		  }
		}
	else {
		switch(msgno) {
		 case WM_KEYUP:
			if (msg.wParam == 0x11)
				ControlKey = 0;
			break;
		 case WM_LBUTTONDBLCLK:
			dblclick_select();
			continue; /* without DispatchMessage or swrite_check */
		 case WM_LBUTTONUP:
			if (ignoreclick) {
				ignoreclick = msgno = 0;
				goto swrite_check;
				}
			if (dblclick) {
				dblclick = 0;
				setsel(dcdw);
				newsel(dw);
				goto swrite_check; /* without DispatchMessage */
				}
			break;
		 case WM_MBUTTONUP:
		 case WM_RBUTTONUP:
			if (ignoreclick) {
				ignoreclick = 0;
				goto swrite_check;
				}
			break;
		 case WM_MBUTTONDOWN:
			if (ignoreclick)
				goto swrite_check;
			break;
		 case WM_LBUTTONDOWN:
			if (ignoreclick)
				goto swrite_check;
			getsel(dw);
			afterup = dw[0] >= unix_point;
			break;
		 case WM_RBUTTONDOWN:
			if (ignoreclick)
				goto swrite_check;
			menuadjust(hrmenu, 0);
		 	if (TrackPopupMenu(hrmenu,
		 			TPM_CENTERALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY,
		 			msg.pt.x, msg.pt.y, 0, mw0, NULL))
			 	newsel(dw);
			break;
		  case WM_NCLBUTTONDOWN:
		  case WM_NCMBUTTONDOWN:
		  case WM_NCRBUTTONDOWN:
			ncbutton = msg.wParam != HTMAXBUTTON;
			break;
		  case WM_NCLBUTTONUP:
		  case WM_NCMBUTTONUP:
		  case WM_NCRBUTTONUP:
			ncbutton = 0;
		 }
		DispatchMessage( &msg );
		if (msgno == WM_LBUTTONUP)
			newsel(dw);
		}
swrite_check:
	if (swrite_waiting == 1) {
		if (control_S)
			swrite_waiting = 2;
		else {
			swrite(swbuf, nswrite);
			swrite_waiting = 0;
			SetEvent(CanRead);
			}
		}
	}
 done:
	UnhookWindowsHookEx(hh);
	Debug(fclose(logf);)
	if (hrmenu)
		DestroyMenu(hrmenu);
	CloseHandle(Sig[0]);
	CloseHandle(Sig[1]);
	ExitProcess(msg.wParam);
	return( msg.wParam );

} /* WinMain */

/*
 * FirstInst - register window class for the application,
 *		   and do any other application initialization
 */
static BOOL FirstInst( HANDLE inst )
{
    WNDCLASSEX	wc;
    BOOL	rc;

    /*
     * set up and register window class
     */
    wc.cbSize = sizeof(wc);
    wc.hIconSm = 0;
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = (LPVOID) WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = sizeof( LPEDATA );
    wc.hInstance = inst;
    wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = GetStockObject( WHITE_BRUSH );
    wc.lpszMenuName = "SwMenu";
    wc.lpszClassName = SwClass;
    rc = RegisterClassEx( &wc );
    return( rc );

} /* FirstInst */

#ifdef WANT_FONTS
typedef struct Fontinfo {
	int nsizes, nsizemax;
	long *sizes;
	char name[LF_FACESIZE];
	char charset;
	char pitchfam;
	} Fontinfo;

typedef struct Fontstuff {
	int nfonts, nfontmax;
	int curfont, cursize;
	Fontinfo *Fi;
	} Fontstuff;

Fontstuff fontstuff;
static char *prev_name;

 static int __stdcall
EnumFontFamExProc( const LOGFONT *logfont, const TEXTMETRIC *textmetric,
		DWORD fonttype, LPARAM data)
{
	Fontstuff *fs = (Fontstuff *)data;
	Fontinfo *fi;

	if(!strcmp(prev_name, logfont->lfFaceName))
		return 1;
	if (fs->nfonts >= fs->nfontmax) {
		fs->nfontmax <<= 1;
		fi = (Fontinfo *)Malloc1(fs->nfontmax * sizeof(Fontinfo));
		memcpy(fi, fs->Fi, fs->nfonts*sizeof(Fontinfo));
		free(fs->Fi);
		fs->Fi = fi;
		}
	fi = fs->Fi + fs->nfonts++;
	fi->nsizes = 0;
	fi->sizes = 0;
	strcpy(prev_name = fi->name, logfont->lfFaceName);
	fi->charset = logfont->lfCharSet;
	fi->pitchfam = logfont->lfPitchAndFamily;
	return 1;
	}

 static int __stdcall
EnumSizeProc( const LOGFONT *logfont, const TEXTMETRIC *textmetric,
		DWORD fonttype, LPARAM data)
{
	Fontinfo *fi = (Fontinfo *)data;
	int i, n = fi->nsizes;
	long h = logfont->lfHeight, *sz = fi->sizes;

	for(i = 0; i < n; i++)
		if (sz[i] == h)
			return 1;
	if (n >= fi->nsizemax) {
		fi->nsizemax <<= 1;
		sz = (long*)Malloc1(fi->nsizemax*sizeof(long));
		memcpy(sz, fi->sizes, n*sizeof(long));
		free(fi->sizes);
		fi->sizes = sz;
		}
	sz[fi->nsizes++] = h;
	return 1;
	}

 static void
GetAllFonts(LPEDATA ed)
{
	HDC	hdc;
	FARPROC	fp;
	Fontinfo *fi, *fie;
	LOGFONT LF;

	if (fontstuff.Fi) {
		fi = fontstuff.Fi;
		fie = fi + fontstuff.nfonts;
		while(fie > fi) {
			--fie;
			if (fie->sizes)
				free(fie->sizes);
			}
		free(fi);
		}
	fontstuff.nfonts = 1;
	fontstuff.nfontmax = 8;
	fi = fontstuff.Fi = (Fontinfo*)Malloc1(fontstuff.nfontmax*sizeof(Fontinfo));
	strcpy(fontstuff.Fi->name, "default");
	*(fi->sizes = (long*)Malloc1(sizeof(long))) = 0;
	fi->nsizes = 1;
	hdc = GetDC( ed->hwnd );
	LF.lfCharSet = DEFAULT_CHARSET;
	LF.lfFaceName[0] = 0;
	LF.lfPitchAndFamily = 0;
	prev_name = "";
	EnumFontFamiliesEx( hdc, &LF, EnumFontFamExProc, (LPARAM)&fontstuff, 0);
	fi = fontstuff.Fi;
	fie = fi + fontstuff.nfonts;
	while(++fi < fie) {
		fi->nsizes = 0;
		fi->nsizemax = 8;
		fi->sizes = (long*)Malloc1(fi->nsizemax*sizeof(long));
		LF.lfCharSet = fi->charset;
		strcpy(LF.lfFaceName, fi->name);
		EnumFontFamiliesEx(hdc, &LF, EnumSizeProc, (LPARAM)fi, 0);
		}
	ReleaseDC( ed->hwnd, hdc );
	}

static HFONT CFont;

static void MakeFont( HWND hwnd, int index, int size )
{
	Fontinfo *fi = fontstuff.Fi + index;

	fontstuff.curfont = index;
	fontstuff.cursize = size;
	if (CFont)
		DeleteObject( CFont );
	CFont = index ? CreateFont(
				fi->sizes[ size ],
				0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE,
				fi->charset,
				OUT_DEFAULT_PRECIS,
				CLIP_DEFAULT_PRECIS,
				DEFAULT_QUALITY,
				fi->pitchfam,
				fi->name )
			: GetStockObject(OEM_FIXED_FONT);

    if( hwnd != NULL ) {
	SendDlgItemMessage( hwnd, FONT_SAMPLE, WM_SETFONT, (UINT)CFont, TRUE );
    }

} /* MakeFont */

 static char *
fontsize(char *buf, int i)
{
	if (!i)
		return "default";
	sprintf(buf, "%d", i);
	return buf;
	}

 BOOL PASCAL
GetFont( HWND hwnd, unsigned msg, UINT wparam, LONG lparam )
{

    int		i, n;
    int		sel,sel2;
    char	str[128];
    WORD	cmd;
    Fontinfo *fi, *fie;
    long *sizes;

    lparam = lparam;	//shut up the compiler for the Win32 version
    switch( msg ) {
    case WM_INITDIALOG:
    	fi = fontstuff.Fi;
    	for(fie = fi + fontstuff.nfonts; fi < fie; fi++) {
	    SendDlgItemMessage( hwnd, FONT_NAME, LB_ADDSTRING, 0,
				(LONG) (LPSTR) fi->name );
	    SendDlgItemMessage( hwnd, FONT_NAME, LB_SETCURSEL, 0, 0L );
	    }
	SendDlgItemMessage(hwnd, FONT_NAME, LB_SETCURSEL, fontstuff.curfont, 0L);
	fi = fontstuff.Fi + fontstuff.curfont;
	sizes = fi->sizes;
	n = fi->nsizes;
	for( i=0; i < n; i++ )
	    SendDlgItemMessage( hwnd, FONT_SIZE, LB_ADDSTRING,
		0, (LONG) fontsize(str,sizes[i]) );
	SendDlgItemMessage(hwnd, FONT_SIZE, LB_SETCURSEL, fontstuff.cursize, 0L);
	MakeFont( hwnd, fontstuff.curfont, fontstuff.cursize);
	return( TRUE );
	break;

    case WM_COMMAND:
        cmd = LOWORD( wparam );
	switch( cmd ) {
	case IDOK:
	    sel = SendDlgItemMessage( hwnd, FONT_NAME, LB_GETCURSEL, 0, 0L );
	    sel2 = SendDlgItemMessage( hwnd, FONT_SIZE, LB_GETCURSEL, 0, 0L );
	    if( sel == LB_ERR  || sel2 == LB_ERR ) {
		EndDialog( hwnd, 0 );
	    } else {
		MakeFont( NULL, sel, sel2 );
		EndDialog( hwnd, 1 );
	    }
	    break;

	case IDCANCEL:
	    EndDialog( hwnd, 0 );
	    break;

	case FONT_SIZE:
	    if( HIWORD(wparam) == LBN_SELCHANGE ) {
		sel = SendDlgItemMessage( hwnd, FONT_NAME, LB_GETCURSEL, 0, 0L );
		if( sel == LB_ERR) break;
		sel2 = SendDlgItemMessage( hwnd, FONT_SIZE, LB_GETCURSEL, 0, 0L );
		if( sel2 == LB_ERR ) break;
		MakeFont( hwnd, sel, sel2 );
	    }
	    break;
	case FONT_NAME:
	    if( HIWORD(wparam) == LBN_SELCHANGE ) {
		sel = SendDlgItemMessage( hwnd, FONT_NAME, LB_GETCURSEL, 0, 0L );
		if( sel == LB_ERR ) break;
		fi = fontstuff.Fi + sel;
		SendDlgItemMessage( hwnd, FONT_SIZE, LB_RESETCONTENT, 0, 0L );
		sizes = fi->sizes;
		n = fi->nsizes;
		for( i = 0; i < n; i++ ) {
		    SendDlgItemMessage( hwnd, FONT_SIZE, LB_ADDSTRING,
				0, (LONG) fontsize(str,sizes[i]) );
		    SendDlgItemMessage( hwnd, FONT_SIZE, LB_SETCURSEL, 0, 0L );
		}
		MakeFont( hwnd, sel, 0 );
	    }
	    break;
	}
      }
    return (FALSE);
    }

 static void
FontSelect( LPEDATA ed )
{
	if( DialogBox(ed->inst, "GetFont", ed->hwnd, GetFont) ) {
		if( ed->font != NULL ) DeleteObject( ed->font );
		ed->font = CFont;
		CFont = 0;
		SendMessage( ed->Swwnd, WM_SETFONT, (UINT)ed->font, TRUE );
		}
	}
#endif /*WANT_FONTS*/
/*
 * AnyInst - do work required for every instance of the application:
 *		  create the window, initialize data
 */
static BOOL AnyInst(HANDLE inst, LPEDATA edata_ptr)
{
	RECT	rect;
	HWND 	hwnd;
	HWND	Swwnd;
	LPEDATA	Ed0;
	UINT	n;

	/*
	* create main window
	*/
	mw0 = hwnd = CreateWindow(
		SwClass,		/* class */
		SwTitle,		/* caption */
		WS_OVERLAPPEDWINDOW,	/* style */
		CW_USEDEFAULT,		/* init. x pos */
		CW_USEDEFAULT,		/* init. y pos */
		CW_USEDEFAULT,		/* init. x size */
		CW_USEDEFAULT,		/* init. y size */
		NULL,			/* parent window */
		NULL,			/* menu handle */
		inst,			/* program handle */
		NULL			/* create parms */
		);
	if( !hwnd )
		return( FALSE );
	GetClientRect( hwnd, &rect );

	mw = Swwnd = CreateWindow(
	    	"EDIT",				/* class */
		NULL,				/* no caption */
		WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL |
		ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL, /* style */
		0,				/* init. x pos */
		0,				/* init. y pos */
		rect.right-rect.left,		/* init. x size (entire parent) */
		rect.bottom-rect.top,		/* init. y size  (entire parent) */
		hwnd,				/* parent window */
		(HMENU)SW_ID,			/* i.d. */
		inst,				/* program handle */
		NULL				/* create parms */
		);

	/*
	* if this failed, then kill original window
	*/
	if( !Swwnd ) {
		DestroyWindow( hwnd );
		return( FALSE );
		}

	SendMessage(mw, EM_SETLIMITTEXT, (WPARAM)(n = SW_WMAX+128), 0);

	/* data for window */
	if (!(Ed0 = edata_ptr)) {
		mw_bytebuf = Malloc1(mw_bblen = n + 8);
		Ed = edata_ptr = Malloc1( sizeof( extra_data ) );
		edata_ptr->inst = inst;
		edata_ptr->filename = NULL;
		edata_ptr->needs_saving = FALSE;
		edata_ptr->font = NULL;
		}
	edata_ptr->hwnd = hwnd;
	edata_ptr->Swwnd = Swwnd;
	SetWindowLong( hwnd, EXTRA_DATA_OFFSET, (DWORD) edata_ptr );

	/*
	* display window
	*/
	ShowWindow( hwnd, SW_SHOWNORMAL );
	UpdateWindow( hwnd );
#ifdef WANT_FONTS
	if (!Ed0) {
		GetAllFonts( edata_ptr );
		edata_ptr->font = GetStockObject(OEM_FIXED_FONT);
		}
	if (edata_ptr->font)
		SendMessage( mw, WM_SETFONT, (WPARAM)edata_ptr->font, TRUE );
#endif

	return( TRUE );

	} /* AnyInst */

 static void
ShutDown(LPEDATA ed, HWND hwnd)
{
	if( CheckFileSave( ed ) ) {
		if (curproc)
			kill();
		exiting = 1;
		SetEvent(CanWait);
		if (await_read)
			SetEvent(CanRead);
		if (await_write)
			SetEvent(CanWrite);
		if (ProcRead)
			Sleep(2);
		if (ProcWrite)
			Sleep(2);
		DestroyWindow( hwnd );
		}
	}

 static void
end_select(void)
{
	Seltype dw[2];

	dw[0] = dw[1] = SendMessage(mw,WM_GETTEXTLENGTH,0,0L);
	setsel(dw);
	}

 static void
swsend(void)
{
	HANDLE h;
	char *s;
	int neednl;

	WaitForSingleObject(CanUpdate,INFINITE);
        SendMessage( mw, WM_COPY, 0, 0L );
        shrink(Clipbdlen(&neednl));
 	end_select();
	afterup = 1;
	SendMessage(mw, WM_PASTE, 0, 0L);
	if (neednl)
		SendMessage(mw, WM_CHAR, '\n', 0L);
	SendMessage(mw, EM_EMPTYUNDOBUFFER, 0, 0L);
	end_select();
	have_nl(1,0,0);
 done:
	SetEvent(CanUpdate);
	}

/*
 * WindowProc - handle messages for the main application window
 */
LONG PASCAL WindowProc( HWND hwnd, unsigned msg,
				     WORD wparam, LONG lparam )
{
    HMENU h;
    LPEDATA ed;
    Seltype dw[2];
    int i;
    static Seltype dws[2];

    ed = (LPEDATA) GetWindowLong( hwnd, EXTRA_DATA_OFFSET );

    /*
     * all messages are in alphabetical order, except WM_COMMAND, at the end
     */
    switch( msg ) {
    case WM_CLOSE:
    	/*
	 * see if it is okay to close down
	 */
	ShutDown(ed,hwnd);
	break;

    case WM_CREATE:
	break;

    case WM_DESTROY:
	if (bugfixing)
		break;
#ifdef WANT_FONTS
    	if(ed->font)
    		DeleteObject( ed->font );
    	if (CFont)
    		DeleteObject(CFont);
#endif
	PostQuitMessage( 0 );
	break;

    case WM_DEVMODECHANGE:
    case WM_WININICHANGE:
	break;

    case WM_FONTCHANGE:
#ifdef WANT_FONTS
	GetAllFonts( ed );
#endif
	break;

    case WM_INITMENU:
	if( h = GetMenu( hwnd ) )
		menuadjust(h,1);
	return 0;

    case WM_QUERYENDSESSION:
    	/*
	 * check if it is okay to end the session
	 */
	return( CheckFileSave( ed ) );

    case WM_SETFOCUS:
    	/*
	 * move the focus to our Swor, rather than to the frame
	 */
	SetFocus( ed->Swwnd );
	break;

    case WM_SIZE:
    	/*
	 * resize Sw window to match size of our client area
	 */
	MoveWindow( ed->Swwnd, 0, 0, LOWORD( lparam ),
			HIWORD( lparam ), TRUE );
	break;


    case WM_COMMAND:
    	switch( wparam ) {
	case SW_ID:
	    switch( HIWORD( lparam ) ){
	    case EN_CHANGE:
	    	ed->needs_saving = TRUE;
		break;
	    case EN_ERRSPACE:
	    	getsel(dw);
	    	dws[1] = unix_point >> 1;
	    	setsel(dws);
		SendMessage( ed->Swwnd, WM_CUT, 0, 0L );
		unix_point -= dws[1];
		if (dws[1] < dw[1] && dws[1] <= dw[0]) {
			dw[0] -= dws[1];
			dw[1] -= dws[1];
			setsel(dw);
			}
	    	/*MessageBox( hwnd, "Out of Space", SwTitle, MB_ok );*/
		break;
	    }
	    break;
	case MENU_SEND:
		swsend();
		break;
	case MENU_CLEAR:
		WaitForSingleObject(CanUpdate,INFINITE);
		getsel(dw);
		SendMessage(ed->Swwnd, WM_CLEAR, 0, 0);
		upcheck(dw);
		break;
	case MENU_COPY:
		copy();
		break;
	case MENU_CUT:
		cut();
		break;
	case MENU_EXIT:
		ShutDown(ed,hwnd);
		break;
#ifdef WANT_FONTS
	case MENU_FONT_SELECT:
		FontSelect( ed );
		break;
#endif
	case MENU_ALL_SELECT:
		WaitForSingleObject(CanUpdate,INFINITE);
		AllSelect( ed );
		SetEvent(CanUpdate);
		break;
	case MENU_PASTE:
		paste();
		break;
	case MENU_UNDO:
		WaitForSingleObject(CanUpdate,INFINITE);
		SendMessage( ed->Swwnd, EM_UNDO, 0, 0L );
		SetEvent(CanUpdate);
		break;
	case MENU_KILL:
		if (curproc)
			kill();
		break;
	case MENU_USAGE:
		Usage();
		break;
	case MENU_ABOUT:
		About();
		break;
	case MENU_DEBUG:
		getsel(dw);
		i = sprintf(msgbuf,
			"unix_point = %u, dw[0] = %u, dw[1] = %u\n"
			"afterup = %d, textlen = %d, maxlen = %d",
			unix_point, dw[0], dw[1], afterup,
			SendMessage(mw,WM_GETTEXTLENGTH,0,0L),
			SendMessage(mw,EM_GETLIMITTEXT,0,0L));
		if (Eb.L1)
			sprintf(msgbuf+i,
				"\nswrite has L = %ld, L1 = %ld, nbs = %d"
				"\nL0 = %ld, L1 - L = %ld, nsent = %d",
				Eb.L, Eb.L1, Eb.nbs, Eb.L0, Eb.L1 - Eb.L, Eb.nsent);
		MessageBox(NULL, msgbuf, "sw debug", MB_ok);
		break;
	case MENU_FAST:
		if (!fastswrite)
			showfast(hwnd, fastswrite = 1, escml);
		break;
	case MENU_SLOW:
		if (fastswrite)
			showfast(hwnd, fastswrite = 0, escml);
		break;
	case MENU_ELK:
		if (escml) {
			if (multiline) {
				multiline = 0;
				adjust_title();
				have_nl(0,0,0);
				}
			showfast(hwnd, fastswrite, escml = 0);
			}
		break;
	case MENU_EML:
		if (!escml)
			showfast(hwnd, fastswrite, escml = 1);
		break;
	case MENU_SENDALL:
		if (tocursor) {
			tocursor = 0;
			showfast(hwnd, fastswrite, escml);
			}
		break;
	case MENU_TOCURSOR:
		if (!tocursor) {
			tocursor = 1;
			showfast(hwnd, fastswrite, escml);
			}
		break;
	case MENU_CLEARHIST:
		clear_hist();
		break;
	case MENU_SIGINT:
		sigsend(SIGINT, 0);
		break;
	case MENU_CLEARCLIPBD:
		if (OpenClipboard(mw)) {
			EmptyClipboard();
			CloseClipboard();
			}
		break;
	case MENU_C_AS_B:
		if (!c_as_b) {
			c_as_b = 1;
			showfast(hwnd, fastswrite, escml);
			}
		break;
	case MENU_NO_C_AS_B:
		if (c_as_b) {
			c_as_b = 0;
			showfast(hwnd, fastswrite, escml);
			}
		break;
	}
	break;

    default:
	return( DefWindowProc( hwnd, msg, wparam, lparam ) );
    }
    return( 0L );

} /* WindowProc */
