\"			-*-Text-*-
.TH tskstart l "" "" "\fBCray Compatibility Library: libCRAY.a\fP" 
.SH NAME
tskstart \- Initiate a multiprocessing task at the subroutine level
.SH SYNOPSIS
.B external taskhead
.br
\fBcall tskstart( taskarry, taskhead [, list] )\fR
.br
.B integer taskarry(\&3)
.SH ARGUMENTS
.B taskarry
.RS
Task control array for this task (should be in shared memory).
Word 1 must be set to the integer length of this array and must be
either 2 or 3 (3 in the example above).  Word 3, if used, may be set
to any value by the user.
On return, word 2 will contain a unique task identifier that may be
used to perform other functions on the created task.
The unique identifier must be maintained if any subsequent interaction
with the task is desired.
.RE
.B taskhead
.RS
External entery point at which task execution begins.
This name must be declared \fIEXTERNAL\fR in the routine making the
call to \fItskstart\fR.
.RE
.B list
.RS
Optional list of (at most 20) arguments passed to the new task.
This list must corespond to the argument list of the external entry
point taskhead
.RE
.SH DESCRIPTION
This routine initiates a UNIX process via a call to \fIfork\fR and
associates a task with that process by initializing the necessary data
structures (ie, the task descriptor).
Upon return from this routine, the requested task will be ready to
execute in the UNIX process.  
There is no implicit execution order between the calling task and the
tasks it creates.
Subsequent references to a specific task are made utilizing the task's
task control array, \fItaskarry\fR.
.PP
Shared memory is set up on the first call that a user job makes to
\fItskstart\fR via a call to \fIcreate_shared_region\fR.  
The calling program must have been linked with a dummy Fortran
subroutine that declares all common blocks that are to be shared.
This routine must also include the Cray Compatibility library book
mark common blocks contained in the include files in
/usr/local/include/tskcombgn.h and /usr/local/include/tskcomend.h.
The sequence of things is important.
The taskcombgn.h comes first then the user common blocks and then
tskcomend.h (see the example, below).
There must be no other executable statements in the dummy routine.
On the load line, the dummy routine's object file must be the first
file in the object file list.
A typical dummy routine looks like the following
.nf
.RS
subroutine dummy
include '/usr/local/include/tskcombgn.h'
include 'mycommons.h'
include '/usr/local/include/tskcomend.h'
end
.RE
.fi
where mycommons.h is an include file which declares all of the common
blocks that should be in shared memory.
.SH FILES
.nf
/usr/local/lib/libCRAY.a		Library
/usr/local/include/tskcombgn.h	Book mark for the shared memory region
/usr/local/include/tskcomend.h	Book mark for the shared memory region
.fi
.SH "SEE ALSO"
\fItskwait(l)\fR, \fItsktest(l)\fR, \fItskvalue(l)\fR, \fIlogopen(l)\fR
.SH DIAGNOSTICS
.SH BUGS
