\"	-*-Text-*-
.TH evtest l "" "" "\fBCray Compatibility Library: libCRAY.a\fP" 
.SH NAME
evtest \- Test the state of an Event
.SH SYNOPSIS
.B logical evtest, istat
.br
.B istat = evtest( event )
.SH ARGUMENTS
.B event
.RS
Integer variable (in shared memory) used as an event.
.RE
.SH RETURNS
.B istat
.RS
A Fortran logical .TRUE. if the indicated event is posted.
A Fortran logical .FALSE. if the indicated event has never been posted
or is cleared.
The event variable's state is unaffected by this call.
.RE
.SH DESCRIPTION
This routine tests the state of the indicated event.
If the event has never been posted or has been cleared the routine
returns a Fortran .FALSE. to the calling task.
If the event is posted the routine returns a Fortran .TRUE. to the
calling task.
.PP
Care should be taken when using this routine in a multiprocessing job.
The value returned may be invalidated shortly after, or just before it
is returned.
That is to say the returned value is valid at the time the
\fIevtest\fR checks the appropriate data structure,
however since concurrent execution is possible, the status
may have changed by the time the routine returns the status.
.SH FILES
/usr/local/lib/libCRAY.a
.SH "SEE ALSO"
\fIevasgn(l)\fR, \fIevrel(l)\fR, \fIevpost(l)\fR, \fIevclear(l)\fR,
\fIevwait(l)\fR
.SH BUGS
