c                     CRAY COMPATABILITY LIBRARY
c         Routines that deal with the MAT/GMAT tracing mechanisms.
c
c   (c) Copyright 1987 the Regents of the University of California,
c    Lawrence Livermore National Laboratory.  All Rights Reserved.
c $Locker:  $
c $Revision: 1.0 $
c $Log:	logs.f,v $
c Revision 1.0  87/09/12  15:25:38  seager
c Initial Release
c 
c $Header: logs.f,v 1.0 87/09/12 15:25:38 seager Rel $
c
      subroutine lgdsable
      include 'tskcomend.h'
c         Disables the logging.
      loggon = 0
      return
      end
      subroutine lgenable
      include 'tskcomend.h'
c         enables the logging.
      loggon = 1
      return
      end
      subroutine lgentry( nevent, info, length )
      integer nevent, info(length), length
      integer lg_buf(12)
      include 'tskcomend.h'
      integer pid, getpid, tid, gettid
      external getpid, gettid
c
c         This routine allows the user to log and entry.
c
D      write(6,1020) nevent, loggon, lgentryon
      if( loggon.eq.0 ) return
      if( lgentryon.eq.0 ) return
      if( nevent.lt.0 .or. nevent.gt.200 ) then
         write(0,1000) nevent
         call exit( 1 )
      endif
c
c         Get my Unix process and local task id.
c
      if( nevent.eq.129 .or.
     $     nevent.eq.145 .or. nevent.eq.150 ) then
c         tid, pid of new task, info(1) is tid of task that forked.
         tid = info(1)
         pid = info(2)
         info(1) = gettid()
      else if( nevent.eq.132 ) then
c         tid, pid of new task, info(1) is tid of new task.
         tid = info(1)
         pid = info(2)
      else if( nevent.eq.133 ) then
         tid = gettid()
         info(1) = tid-1
      else
         tid = gettid()
         pid = getpid()
      endif
c
c         Call the c routine to build the log entry in buf.
c
      call s_lockon( loglok )
      call c_lgentry( nevent, info, length, tid, pid, lg_buf )
C         The next two lines are used for logging while running.
D      write(lg_fid) (lg_buf(i),i=1,2*(length+2))
D      call flush( lg_fid )
      call s_lockoff( loglok )
D      write(6,1010) 2*(length+2),(lg_buf(i),i=1,2*(length+2))
      return
 1000 format(' LGENTRY: Error #1: User Event out of range - EVENT = ',
     $     i10)
D 1010 format(' LGENTRY: Task event of length ',i3,' follows'/(5i10))
D 1020 format(' LGENTRY: nevent, loggon, lgentryon = ',3i5)
      end
      subroutine lgoff
      include 'tskcomend.h'
      integer getpid
      external getpid
c         This routine turns *OFF* the user loggin mechinism
D      write(6,1000) getpid(), lgentryon
D 1000 format(' LGOFF: Task ',i5,' Turning off logging = ',i2)
      lgentryon = 0
      return
      end
      subroutine lgon
      integer info(10), getpid
      double precision urtc
      external urtc, getpid
c
      include 'tskcomend.h'
c
c         This routine turns *ON* the user loggin mechinism
c         It also logs the start of the first task (which occured when
c         the user first started the job).
c
      lgentryon = 1
c
c         And then their was Light...Set up task 1.
c         Get the clock
      startime = urtc( idummy )
      numtsk = 1
      tskarry(1,1) = 3
      tskarry(2,1) = 1
      tskarry(3,1) = getpid()
      info(1)  = ifix(sngl(startime*1.0E-6))
D      write(6,1000) startime, info(1)
      call lgentry( 128, info, 1 )
      return
D 1000 format(' LGON: startime = ',e16.7,' istartime = ',i10)
      end
      subroutine lgclose
c
c         This routine closes the logging file.
c
      include 'tskcomend.h'
      external c_dump_trcbuf
c
D      close( lg_fid )
D      open( lg_fid, file='trace.final',access='sequential',
D     $      form='unformatted',recordtype='variable',
D     $     organization='stream')
c
c         We only have a pointer to the internal buffer.  The following
c         (Kludge) call to a C routine is required beause FX/Fortrash does
c         not support pointers...
      call c_dump_trcbuf
      close( lg_fid )
      return
      end
      subroutine lgopen( ibufr, length, nfile, icreate )
      integer ibufr(length), length, icreate, ifile
      character*80 nfile, mfile
      equivalence (ifile,mfile)
      include 'tskcomend.h'
c
c         Initiates the MAT logging.
c
      mfile = nfile
      if( ibufr(1).eq.-1 ) then
         write(0,1000) length
         call exit( 1 )
      endif
      if( length.lt.250 ) then
         write(0,1010) length
         call exit( 1 )
      endif
      if( ifile.eq.-1 ) then
         write(0,1020) 
         call exit( 1 )
      endif
      ibufaddr = loc( ibufr(1) )
      ibufcur  = loc( ibufr(1) )
      ibuflen  = length
      iwrap    = 0
      lg_fid = 63
      open( lg_fid, file=nfile,access='sequential',
     $     form='unformatted',recordtype='variable',
     $     organization='stream')
      return
 1000 format(' LGOPEN: Error #99: User must allocate space for the',
     $     ' buffer of length ',i7/
     $     ' ====>Be sure that you allocate *SHARED* memory')
 1010 format(' LGOPEN: Error: Minimum buffer size for event buffer'
     $     ' is 250 (32 bit) words')
 1020 format(' LGOPEN: Error: User must specify output file name')
      end
      subroutine dump_trcbuf( lg_fid, ibuf, ibufcur, len, iwrap )
      integer lg_fid, ibuf(1), ibufcur(1), len, iwrap
c
c         This routine dumps out the internal user supplied buffer, ibuf.
c
      if( iwrap.eq.0 ) then
c
c         No wrap of the user supplied internal buffer has occured.
c         Simply write it out.
c
         numints = (loc(ibufcur(1)) - loc(ibuf(1))+1)/4
         write(lg_fid) (ibuf(i), i = 1, numints)
      else
c
c         We got a wrap.  Write from ibufcur(1) to the end.
c
         numints = len - (loc(ibufcur(1)) - loc(ibuf(1)))/4
         write(lg_fid) (ibufcur(i), i = 1, numints)
c
c         Write from the start to ibufcur(1)-1.

         numints = (loc(ibufcur(1)) - loc(ibuf(1)))/4
         write(lg_buf) (ibufcur(i), i = 1, numints)
      endif
c
c         Like all done.
      return
      end
