/* Common block structure for the C routines.  Must conform to the
 * Fortrash common block /tskbgn/
 * $Locker:  $
 * $Revision: 1.0 $
 * $Log:	c_tskcomend.h,v $
 * Revision 1.0  87/09/12  15:25:45  seager
 * Initial Release
 * 
 * $Header: c_tskcomend.h,v 1.0 87/09/12 15:25:45 seager Rel $
 */
struct tskbgn {
    int      tskarry[3*100];	/* Task array descriptors */
    int	     numtsk;		/* Number of tasks */
    int      rootpid;		/* Process id of the root Task */
    int	     tsklok;		/* Lock for tasking library */
    int      barlok[4*16*20];	/* Barrier Lock space */
    int      barcount[20];	/* Number of tasks for each bar */
    int      barwhoami[20];	/* Counters for each barrier */
    int      numbar;		/* Number of barriers allocated so far */
    double   startime;		/* Number of microseconds from midnight 
				 * 1/1/1970 */
    int	     loggon;		/* Loggin on flag. */
    int	     lgentryon;		/* Flag to log events. */
    int	     loglok;		/* Lock for the loggin */
    int	     lg_fid;		/* File descriptor for the logggin file. */
    unsigned *ibufaddr;		/* Address of the interal logging buffer. */
    unsigned *ibufcur;		/* Address of next position in the circular
				 * logging buffer. */
    int      ibuflen;		/* Length of the internal logging buffer. */
    int      iwrap;		/* Number of times the circular buffer wrapped
				 * over upon it's self. */
};
