/*	Work routines for the loggin mechinism.
 * $Locker:  $
 * $Revision: 1.0 $
 * $Log:	c_logs.c,v $
 * Revision 1.0  87/09/12  15:25:44  seager
 * Initial Release
 * 
 */

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */

#include "c_tskcomend.h"
#include <sys/file.h>
#include <sys/time.h>
#define MODE	0x666

static char rcsid[] = "$Header: c_logs.c,v 1.0 87/09/12 15:25:44 seager Rel $";

extern struct tskbgn tskbgn_;

struct log_entry_templet {
    unsigned foo : 2;		/* Bits  0: 1 ignore */
    unsigned len : 4;		/* Bits  3: 6 number of words in the ADD */
    unsigned actno : 10;	/* Bits  7:16 Action Number */
    unsigned pid : 6;		/* Bits 17:22 Process ID */
    unsigned clock_hi : 10;	/* Bits 23:32 Hi 10 bits of real time clock */
    unsigned clock;		/* Bits  0:32 Lo word of RTC  */
    unsigned tdaddr;		/* Bits  0:32 MemLoc of task Ident */
    unsigned tid;		/* Bits  0:32 Task ID */
};
      
void c_lgentry_( pnevent, info, plength, ptid, ppid, lg_buf )
int *pnevent, info[], *plength, *ptid, *ppid, *lg_buf;
{
    struct log_entry_templet log_entry;
    struct timeval real_time;
    struct timezone real_zone;
    unsigned int buf[32], *pbuf;
    int i, siz_entry;
    double urtc_();
    unsigned long nowtime;

    /* Circular buffer addresses */
    unsigned *ibufaddr = tskbgn_.ibufaddr;
    int ibuflen   = tskbgn_.ibuflen;
    int lg_fid    = tskbgn_.lg_fid;
    int iwrap	  = tskbgn_.iwrap;

    log_entry.actno  = *pnevent;
    log_entry.pid    = *ptid-1;
    log_entry.tid    = *ptid;
    log_entry.tdaddr = *ppid;

    nowtime = (unsigned long)(urtc_( i ) - tskbgn_.startime);
    log_entry.clock_hi = 0;
    log_entry.clock    = nowtime;

    /* Set up the action dependent data
     * Length given in 32 bit words.  Output in 64 bit words. 
     */
    log_entry.len = *plength+2;
    for( i=0; i<*plength; i++ ) {
	buf[2*i]   = 0;
	buf[2*i+1] = (unsigned)info[i];
    }

    /* Write out the data */
    siz_entry = sizeof(log_entry)/sizeof(int);
    bcopy( &log_entry, lg_buf, sizeof(log_entry) );
    bcopy( buf, lg_buf+siz_entry, *plength*8 );
#ifdef DEBUG
    print_log( log_entry, buf, lg_buf, *plength );
#endif

    /* Copy the log_entry into the internal buffer. */
    pbuf = (unsigned int *)&log_entry;
    *(tskbgn_.ibufcur++) = *pbuf;
    if( tskbgn_.ibufcur >= ibufaddr+ibuflen ) { 
	tskbgn_.ibufcur = ibufaddr, iwrap++; 
    }
    *(tskbgn_.ibufcur++) = *(pbuf+1);
    if( tskbgn_.ibufcur >= ibufaddr+ibuflen ) { 
	tskbgn_.ibufcur = ibufaddr, iwrap++; 
    }
    *(tskbgn_.ibufcur++) = *(pbuf+2);
    if( tskbgn_.ibufcur >= ibufaddr+ibuflen ) { 
	tskbgn_.ibufcur = ibufaddr, iwrap++; 
    }
    *(tskbgn_.ibufcur++) = *(pbuf+3);
    if( tskbgn_.ibufcur >= ibufaddr+ibuflen ) { 
	tskbgn_.ibufcur = ibufaddr, iwrap++; 
    }
    for( i=0; i<*plength*2; i++ ) {
	*(tskbgn_.ibufcur++) = buf[i];
	if( tskbgn_.ibufcur >= ibufaddr+ibuflen ) { 
	    tskbgn_.ibufcur = ibufaddr, iwrap++; 
	}
    }	
}
double urtc_( idummy )
int idummy;
/*
 * This routine returns the "Real Time" in microseconds.
 */
{
    struct timeval real_time;
    struct timezone real_zone;
    double temp;

    gettimeofday( &real_time, &real_zone );
    temp = (double)real_time.tv_sec*1.0e+6 + (double)real_time.tv_usec;

    return( temp );
}
print_log(log_entry, buf, lg_buf, add_len)
struct log_entry_templet log_entry;
int *buf, *lg_buf, add_len;
{
    struct log_entry_templet *lg_copy;
    int i, flen, *plg, siz_entry;

    lg_copy = (struct log_entry_templet *)lg_buf;
    siz_entry = sizeof(log_entry)/sizeof(int);
    printf("\nPRINT_LOG: Log entry follows...sizeof(log_entry) = %d\n",
	   siz_entry);
    printf("action is %10d copy is %10d\n", log_entry.actno,lg_copy->actno );
    printf("length is %10d copy is %10d\n", log_entry.len,lg_copy->len );
    printf("procss is %10d copy is %10d\n", log_entry.pid,lg_copy->pid );
    printf("clock  is %10d copy is %10d\n", log_entry.clock,lg_copy->clock );
    printf("tskadr is %10d copy is %10d\n", log_entry.tdaddr,lg_copy->tdaddr );
    printf("tsknmb is %10d copy is %10d\n", log_entry.tid,lg_copy->tid );
    plg = lg_buf + siz_entry;
    printf("Action dependent data follows.\n");
    for( i=0; i<add_len; i++ )
      printf("%10d %10d | %10d %10d\n",buf[2*i],buf[2*i+1], 
	     *(plg+2*i), *(plg+2*i+1));
    plg = lg_buf;
    printf("LGENTRY should print out\n");
    for( i=0; i<log_entry.len; i++ ) {
	printf("%10d %10d\n",*(plg+2*i),*(plg+2*i+1));
    }
}
/* This routine is necessary to dereference the pointer to the user
 * supplied internal buffer.
 */
void c_dump_trcbuf_()
{
    /* Circular buffer addresses */
    unsigned *ibufaddr = tskbgn_.ibufaddr;
    unsigned *ibufcur  = tskbgn_.ibufcur;
    int ibuflen   = tskbgn_.ibuflen;
    int lg_fid    = tskbgn_.lg_fid;
    int iwrap	  = tskbgn_.iwrap;
    void dump_trcbuf_();

    dump_trcbuf_( &lg_fid, ibufaddr, ibufcur, &ibuflen, &iwrap );
}
