/* Barrier(whoami, howmany) implements a barrier for howmany processes.
 * You tell it who you think you are and how many processes should participate.
 *  whoami = (0,howmany-1)
 * $Locker:  $
 * $Revision: 1.0 $
 * $Log:	barrier.c,v $
 * Revision 1.0  87/09/12  15:25:41  seager
 * Initial Release
 * 
 */

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */

static char rcsid[] = "$Header: barrier.c,v 1.0 87/09/12 15:25:41 seager Rel $";

#include <stdio.h>

#define ABORTBARRIER	fprintf(stderr, "barrier(%d, %d) : bad arg\n", whoami, howmany);\
exit(1);

#define LNMAXPROC	4		/* The base 2 log of MAXPROC */
#define MAXPROC		(1<<LNMAXPROC)	/* The max number of procs. */


#undef CHECK	/* If you do not have all code set up in FAST mode define
		   CHECK for careful argument checking.  Turning on the FAST
		   mode improves the speed of execution by just a few percent
		   and provides argument checking without any overhead.  It
		   also increases the size of the code by a large factor.
		   */

#define	FAST2	/* Larger but faster code for 2 processors. */
#define	FAST4	/* Larger but faster code for 3-4 processors. */
#define	FAST8	/* Larger but faster code for 5-8 processors. */

#define	CASE16	/* Define if you want code for 9-16 processors. */
#define	FAST16	/* Larger but faster code for 9-16 processors. */

#undef	CASE32	/* Define if you want code for 17-32 processors. */
#undef	FAST32	/* Larger but faster code for 17-32 processors. */

#define UNLOCK(lckaddr, i, j)	{register int *lptr = (lckaddr+i*MAXPROC)+j;\
				   while(*lptr);\
				     *lptr = 1;}
#define LOCK(lckaddr, i, j)	{register int *lptr = (lckaddr+i*MAXPROC)+j;\
				   while(!*lptr);\
				     *lptr = 0;}

/* The WORK#(i) macro implements the work for an # level barrier.
 * The argument i is who you are.  The WORK#M(i) macro is the work
 * section for a processor that has to do extra work for a missing
 *  reflection processor.
 */
#define WORK1(lckaddr,i)	UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i);

#define WORK2(lckaddr,i)	UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i);\
UNLOCK(lckaddr,1, (i^(1<<1))); LOCK(lckaddr,1, i);

#define WORK2M(lckaddr,i)	UNLOCK(lckaddr,0, ((i^0x3)^(1<<0)));\
UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i); LOCK(lckaddr,0, (i^0x3));\
UNLOCK(lckaddr,1, ((i^0x3)^(1<<1))); UNLOCK(lckaddr,1, (i^(1<<1)));\
LOCK(lckaddr,1, i); LOCK(lckaddr,1, (i^0x3));

#define WORK3(lckaddr,i)	UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i);\
UNLOCK(lckaddr,1, (i^(1<<1))); LOCK(lckaddr,1, i);\
UNLOCK(lckaddr,2, (i^(1<<2))); LOCK(lckaddr,2, i);

#define WORK3M(lckaddr,i)	UNLOCK(lckaddr,0, ((i^0x7)^(1<<0)));\
UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i); LOCK(lckaddr,0, (i^0x7));\
UNLOCK(lckaddr,1, ((i^0x7)^(1<<1))); UNLOCK(lckaddr,1, (i^(1<<1)));\
LOCK(lckaddr,1, i); LOCK(lckaddr,1, (i^0x7));\
UNLOCK(lckaddr,2, ((i^0x7)^(1<<2))); UNLOCK(lckaddr,2, (i^(1<<2)));\
LOCK(lckaddr,2, i); LOCK(lckaddr,2, (i^0x7));

#define WORK4(lckaddr,i)	UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i);\
UNLOCK(lckaddr,1, (i^(1<<1))); LOCK(lckaddr,1, i);\
UNLOCK(lckaddr,2, (i^(1<<2))); LOCK(lckaddr,2, i);\
UNLOCK(lckaddr,3, (i^(1<<3))); LOCK(lckaddr,3, i);

#define WORK4M(lckaddr,i)	UNLOCK(lckaddr,0, ((i^0xf)^(1<<0)));\
UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i); LOCK(lckaddr,0, (i^0xf));\
UNLOCK(lckaddr,1, ((i^0xf)^(1<<1))); UNLOCK(lckaddr,1, (i^(1<<1)));\
LOCK(lckaddr,1, i); LOCK(lckaddr,1, (i^0xf));\
UNLOCK(lckaddr,2, ((i^0xf)^(1<<2))); UNLOCK(lckaddr,2, (i^(1<<2)));\
LOCK(lckaddr,2, i); LOCK(lckaddr,2, (i^0xf));\
UNLOCK(lckaddr,3, ((i^0xf)^(1<<3))); UNLOCK(lckaddr,3, (i^(1<<3)));\
LOCK(lckaddr,3, i); LOCK(lckaddr,3, (i^0xf));

#define WORK5(lckaddr,i)	UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i);\
UNLOCK(lckaddr,1, (i^(1<<1))); LOCK(lckaddr,1, i);\
UNLOCK(lckaddr,2, (i^(1<<2))); LOCK(lckaddr,2, i);\
UNLOCK(lckaddr,3, (i^(1<<3))); LOCK(lckaddr,3, i);\
UNLOCK(lckaddr,4, (i^(1<<4))); LOCK(lckaddr,4, i);

#define WORK5M(lckaddr,i)	UNLOCK(lckaddr,0, ((i^0x1f)^(1<<0)));\
UNLOCK(lckaddr,0, (i^(1<<0)));\
LOCK(lckaddr,0, i); LOCK(lckaddr,0, (i^0x1f));\
UNLOCK(lckaddr,1, ((i^0x1f)^(1<<1))); UNLOCK(lckaddr,1, (i^(1<<1)));\
LOCK(lckaddr,1, i); LOCK(lckaddr,1, (i^0x1f));\
UNLOCK(lckaddr,2, ((i^0x1f)^(1<<2))); UNLOCK(lckaddr,2, (i^(1<<2)));\
LOCK(lckaddr,2, i); LOCK(lckaddr,2, (i^0x1f));\
UNLOCK(lckaddr,3, ((i^0x1f)^(1<<3))); UNLOCK(lckaddr,3, (i^(1<<3)));\
LOCK(lckaddr,3, i); LOCK(lckaddr,3, (i^0x1f));\
UNLOCK(lckaddr,4, ((i^0x1f)^(1<<4))); UNLOCK(lckaddr,4, (i^(1<<4)));\
LOCK(lckaddr,4, i); LOCK(lckaddr,4, (i^0x1f));

void tsk_bar_( pwhoami, phowmany, clckaddr)
     int *pwhoami;	/* Who am I? (0 <= whoami < howmany) */
     int *phowmany;	/* The number participating. (howmany >= 1) */
     int *clckaddr;
{
    register int whoami, howmany, *lckaddr;

    whoami = *pwhoami, howmany = *phowmany, lckaddr = clckaddr;
    
#ifdef CHECK
    if(whoami < 0 || whoami >= howmany) {
	ABORTBARRIER;
    }
#endif
    
    switch(howmany) {
      case 1:
	if(whoami != 0) {
	    ABORTBARRIER;
	}
	break;
      case 2:
#ifdef FAST2
	switch(whoami) {
	  case 0: 
	    WORK1(lckaddr,0); break;
	  case 1: 
	    WORK1(lckaddr,1); break;
	  default: ABORTBARRIER; break;
	}
#else
	WORK1(lckaddr,whoami);
#endif
	break;
      case 3:
#ifdef FAST4
	switch(whoami) {
	  case 0: WORK2M(lckaddr,0); break;
		case 1: WORK2(lckaddr,1); break;
		case 2: WORK2(lckaddr,2); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 1) {
	    WORK2M(lckaddr,whoami);
	}
	else {
	    WORK2(lckaddr,whoami);
	}
#endif
	break;
      case 4:
#ifdef FAST4
	switch(whoami) {
	  case 0: WORK2(lckaddr,0); break;
	  case 1: WORK2(lckaddr,1); break;
	  case 2: WORK2(lckaddr,2); break;
	  case 3: WORK2(lckaddr,3); break;
	  default: ABORTBARRIER; break;
	}
#else
	WORK2(lckaddr,whoami);
#endif
	break;
      case 5:
#ifdef FAST8
	switch(whoami) {
	  case 0: WORK3M(lckaddr,0); break;
		case 1: WORK3M(lckaddr,1); break;
		case 2: WORK3M(lckaddr,2); break;
		case 3: WORK3(lckaddr,3); break;
		case 4: WORK3(lckaddr,4); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 3) {
	    WORK3M(lckaddr,whoami);
	}
	else {
	    WORK3(lckaddr,whoami);
	}
#endif
	break;
      case 6:
#ifdef FAST8
	switch(whoami) {
	  case 0: WORK3M(lckaddr,0); break;
		case 1: WORK3M(lckaddr,1); break;
		case 2: WORK3(lckaddr,2); break;
		case 3: WORK3(lckaddr,3); break;
		case 4: WORK3(lckaddr,4); break;
		case 5: WORK3(lckaddr,5); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 2) {
	    WORK3M(lckaddr,whoami);
	}
	else {
	    WORK3(lckaddr,whoami);
	}
#endif
	break;
      case 7:
#ifdef FAST8
	switch(whoami) {
	  case 0: WORK3M(lckaddr,0); break;
		case 1: WORK3(lckaddr,1); break;
		case 2: WORK3(lckaddr,2); break;
		case 3: WORK3(lckaddr,3); break;
		case 4: WORK3(lckaddr,4); break;
		case 5: WORK3(lckaddr,5); break;
		case 6: WORK3(lckaddr,6); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 1) {
	    WORK3M(lckaddr,whoami);
	}
	else {
	    WORK3(lckaddr,whoami);
	}
#endif
	break;
      case 8:
#ifdef FAST8
	switch(whoami) {
	  case 0: WORK3(lckaddr,0); break;
		case 1: WORK3(lckaddr,1); break;
		case 2: WORK3(lckaddr,2); break;
		case 3: WORK3(lckaddr,3); break;
		case 4: WORK3(lckaddr,4); break;
		case 5: WORK3(lckaddr,5); break;
		case 6: WORK3(lckaddr,6); break;
		case 7: WORK3(lckaddr,7); break;
		default: ABORTBARRIER; break;
	      }
#else
	WORK3(lckaddr,whoami);
#endif
	break;
#ifdef CASE16
      case 9 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4M(lckaddr,0); break;
		case 1: WORK4M(lckaddr,1); break;
		case 2: WORK4M(lckaddr,2); break;
		case 3: WORK4M(lckaddr,3); break;
		case 4: WORK4M(lckaddr,4); break;
		case 5: WORK4M(lckaddr,5); break;
		case 6: WORK4M(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 7) {
	    WORK4M(lckaddr,whoami);
	}
	else {
	    WORK4(lckaddr,whoami);
	}
#endif
	break;
      case 10 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4M(lckaddr,0); break;
		case 1: WORK4M(lckaddr,1); break;
		case 2: WORK4M(lckaddr,2); break;
		case 3: WORK4M(lckaddr,3); break;
		case 4: WORK4M(lckaddr,4); break;
		case 5: WORK4M(lckaddr,5); break;
		case 6: WORK4(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		case 9: WORK4(lckaddr,9); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 6) {
	    WORK4M(lckaddr,whoami);
	}
	else {
	    WORK4(lckaddr,whoami);
	}
#endif
	break;
      case 11 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4M(lckaddr,0); break;
		case 1: WORK4M(lckaddr,1); break;
		case 2: WORK4M(lckaddr,2); break;
		case 3: WORK4M(lckaddr,3); break;
		case 4: WORK4M(lckaddr,4); break;
		case 5: WORK4(lckaddr,5); break;
		case 6: WORK4(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		case 9: WORK4(lckaddr,9); break;
		case 10: WORK4(lckaddr,10); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 5) {
	    WORK4M(lckaddr,whoami);
	}
	else {
	    WORK4(lckaddr,whoami);
	}
#endif
	break;
      case 12 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4M(lckaddr,0); break;
		case 1: WORK4M(lckaddr,1); break;
		case 2: WORK4M(lckaddr,2); break;
		case 3: WORK4M(lckaddr,3); break;
		case 4: WORK4(lckaddr,4); break;
		case 5: WORK4(lckaddr,5); break;
		case 6: WORK4(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		case 9: WORK4(lckaddr,9); break;
		case 10: WORK4(lckaddr,10); break;
		case 11: WORK4(lckaddr,11); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 4) {
	    WORK4M(lckaddr,whoami);
	}
	else {
	    WORK4(lckaddr,whoami);
	}
#endif
	break;
      case 13 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4M(lckaddr,0); break;
		case 1: WORK4M(lckaddr,1); break;
		case 2: WORK4M(lckaddr,2); break;
		case 3: WORK4(lckaddr,3); break;
		case 4: WORK4(lckaddr,4); break;
		case 5: WORK4(lckaddr,5); break;
		case 6: WORK4(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		case 9: WORK4(lckaddr,9); break;
		case 10: WORK4(lckaddr,10); break;
		case 11: WORK4(lckaddr,11); break;
		case 12: WORK4(lckaddr,12); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 3) {
	    WORK4M(lckaddr,whoami);
	}
	else {
	    WORK4(lckaddr,whoami);
	}
#endif
	break;
      case 14 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4M(lckaddr,0); break;
		case 1: WORK4M(lckaddr,1); break;
		case 2: WORK4(lckaddr,2); break;
		case 3: WORK4(lckaddr,3); break;
		case 4: WORK4(lckaddr,4); break;
		case 5: WORK4(lckaddr,5); break;
		case 6: WORK4(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		case 9: WORK4(lckaddr,9); break;
		case 10: WORK4(lckaddr,10); break;
		case 11: WORK4(lckaddr,11); break;
		case 12: WORK4(lckaddr,12); break;
		case 13: WORK4(lckaddr,13); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 2) {
	    WORK4M(lckaddr,whoami);
	}
	else {
	    WORK4(lckaddr,whoami);
	}
#endif
	break;
      case 15 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4M(lckaddr,0); break;
		case 1: WORK4(lckaddr,1); break;
		case 2: WORK4(lckaddr,2); break;
		case 3: WORK4(lckaddr,3); break;
		case 4: WORK4(lckaddr,4); break;
		case 5: WORK4(lckaddr,5); break;
		case 6: WORK4(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		case 9: WORK4(lckaddr,9); break;
		case 10: WORK4(lckaddr,10); break;
		case 11: WORK4(lckaddr,11); break;
		case 12: WORK4(lckaddr,12); break;
		case 13: WORK4(lckaddr,13); break;
		case 14: WORK4(lckaddr,14); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 1) {
	    WORK4M(lckaddr,whoami);
	}
	else {
	    WORK4(lckaddr,whoami);
	}
#endif
	break;
      case 16 :
#ifdef FAST16
	switch(whoami) {
	  case 0: WORK4(lckaddr,0); break;
		case 1: WORK4(lckaddr,1); break;
		case 2: WORK4(lckaddr,2); break;
		case 3: WORK4(lckaddr,3); break;
		case 4: WORK4(lckaddr,4); break;
		case 5: WORK4(lckaddr,5); break;
		case 6: WORK4(lckaddr,6); break;
		case 7: WORK4(lckaddr,7); break;
		case 8: WORK4(lckaddr,8); break;
		case 9: WORK4(lckaddr,9); break;
		case 10: WORK4(lckaddr,10); break;
		case 11: WORK4(lckaddr,11); break;
		case 12: WORK4(lckaddr,12); break;
		case 13: WORK4(lckaddr,13); break;
		case 14: WORK4(lckaddr,14); break;
		case 15: WORK4(lckaddr,15); break;
		default: ABORTBARRIER; break;
	      }
#else
	WORK4(lckaddr,whoami);
#endif
	break;
#endif
#ifdef CASE32
      case 17 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5M(lckaddr,8); break;
		case 9: WORK5M(lckaddr,9); break;
		case 10: WORK5M(lckaddr,10); break;
		case 11: WORK5M(lckaddr,11); break;
		case 12: WORK5M(lckaddr,12); break;
		case 13: WORK5M(lckaddr,13); break;
		case 14: WORK5M(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 15) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 18 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5M(lckaddr,8); break;
		case 9: WORK5M(lckaddr,9); break;
		case 10: WORK5M(lckaddr,10); break;
		case 11: WORK5M(lckaddr,11); break;
		case 12: WORK5M(lckaddr,12); break;
		case 13: WORK5M(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 14) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 19 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5M(lckaddr,8); break;
		case 9: WORK5M(lckaddr,9); break;
		case 10: WORK5M(lckaddr,10); break;
		case 11: WORK5M(lckaddr,11); break;
		case 12: WORK5M(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 13) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 20 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5M(lckaddr,8); break;
		case 9: WORK5M(lckaddr,9); break;
		case 10: WORK5M(lckaddr,10); break;
		case 11: WORK5M(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 12) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 21 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5M(lckaddr,8); break;
		case 9: WORK5M(lckaddr,9); break;
		case 10: WORK5M(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 11) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 22 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5M(lckaddr,8); break;
		case 9: WORK5M(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 10) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 23 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5M(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 9) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 24 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5M(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 8) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 25 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5M(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 7) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 26 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5M(lckaddr,5); break;
		case 6: WORK5(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		case 25: WORK5(lckaddr,25); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 6) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 27 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5M(lckaddr,4); break;
		case 5: WORK5(lckaddr,5); break;
		case 6: WORK5(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		case 25: WORK5(lckaddr,25); break;
		case 26: WORK5(lckaddr,26); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 5) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 28 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5M(lckaddr,3); break;
		case 4: WORK5(lckaddr,4); break;
		case 5: WORK5(lckaddr,5); break;
		case 6: WORK5(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		case 25: WORK5(lckaddr,25); break;
		case 26: WORK5(lckaddr,26); break;
		case 27: WORK5(lckaddr,27); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 4) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 29 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5M(lckaddr,2); break;
		case 3: WORK5(lckaddr,3); break;
		case 4: WORK5(lckaddr,4); break;
		case 5: WORK5(lckaddr,5); break;
		case 6: WORK5(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		case 25: WORK5(lckaddr,25); break;
		case 26: WORK5(lckaddr,26); break;
		case 27: WORK5(lckaddr,27); break;
		case 28: WORK5(lckaddr,28); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 3) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 30 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5M(lckaddr,1); break;
		case 2: WORK5(lckaddr,2); break;
		case 3: WORK5(lckaddr,3); break;
		case 4: WORK5(lckaddr,4); break;
		case 5: WORK5(lckaddr,5); break;
		case 6: WORK5(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		case 25: WORK5(lckaddr,25); break;
		case 26: WORK5(lckaddr,26); break;
		case 27: WORK5(lckaddr,27); break;
		case 28: WORK5(lckaddr,28); break;
		case 29: WORK5(lckaddr,29); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 2) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 31 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5M(lckaddr,0); break;
		case 1: WORK5(lckaddr,1); break;
		case 2: WORK5(lckaddr,2); break;
		case 3: WORK5(lckaddr,3); break;
		case 4: WORK5(lckaddr,4); break;
		case 5: WORK5(lckaddr,5); break;
		case 6: WORK5(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		case 25: WORK5(lckaddr,25); break;
		case 26: WORK5(lckaddr,26); break;
		case 27: WORK5(lckaddr,27); break;
		case 28: WORK5(lckaddr,28); break;
		case 29: WORK5(lckaddr,29); break;
		case 30: WORK5(lckaddr,30); break;
		default: ABORTBARRIER; break;
	      }
#else
	if(whoami < 1) {
	    WORK5M(lckaddr,whoami);
	}
	else {
	    WORK5(lckaddr,whoami);
	}
#endif
	break;
      case 32 :
#ifdef FAST32
	switch(whoami) {
	  case 0: WORK5(lckaddr,0); break;
		case 1: WORK5(lckaddr,1); break;
		case 2: WORK5(lckaddr,2); break;
		case 3: WORK5(lckaddr,3); break;
		case 4: WORK5(lckaddr,4); break;
		case 5: WORK5(lckaddr,5); break;
		case 6: WORK5(lckaddr,6); break;
		case 7: WORK5(lckaddr,7); break;
		case 8: WORK5(lckaddr,8); break;
		case 9: WORK5(lckaddr,9); break;
		case 10: WORK5(lckaddr,10); break;
		case 11: WORK5(lckaddr,11); break;
		case 12: WORK5(lckaddr,12); break;
		case 13: WORK5(lckaddr,13); break;
		case 14: WORK5(lckaddr,14); break;
		case 15: WORK5(lckaddr,15); break;
		case 16: WORK5(lckaddr,16); break;
		case 17: WORK5(lckaddr,17); break;
		case 18: WORK5(lckaddr,18); break;
		case 19: WORK5(lckaddr,19); break;
		case 20: WORK5(lckaddr,20); break;
		case 21: WORK5(lckaddr,21); break;
		case 22: WORK5(lckaddr,22); break;
		case 23: WORK5(lckaddr,23); break;
		case 24: WORK5(lckaddr,24); break;
		case 25: WORK5(lckaddr,25); break;
		case 26: WORK5(lckaddr,26); break;
		case 27: WORK5(lckaddr,27); break;
		case 28: WORK5(lckaddr,28); break;
		case 29: WORK5(lckaddr,29); break;
		case 30: WORK5(lckaddr,30); break;
		case 31: WORK5(lckaddr,31); break;
		default: ABORTBARRIER; break;
	      }
#else
	WORK5(lckaddr,whoami);
#endif
	break;
#endif
      default:
	ABORTBARRIER;
	break;
    }
}
