% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_utilities.R
\name{import_rb}
\alias{import_rb}
\title{Import a ReaderBench output file (.csv) into R.}
\usage{
import_rb(path)
}
\arguments{
\item{path}{A string giving the path and filename to import.}
}
\value{
A base \code{data.frame} with one row per record and the following columns:
\itemize{
  \item \code{ID} (\code{character}): unique identifier of the text/essay.
  \item One column per retained ReaderBench feature, kept by original
        feature name (\code{numeric}). Feature names mirror the ReaderBench
        output variables.
}
The object has class \code{data.frame} (or \code{tibble} if converted by the user).
}
\description{
When available, the function reads the header of the packaged sample
(\code{inst/extdata/sample_rb.csv}) and keeps the first 404 columns by NAME
(plus the \code{File.name}/\code{ID} column), excluding any columns with names
appearing after position 404 in that header. If the sample is unavailable,
it falls back to keeping the first 404 columns by position.
}
\examples{
# Fast, runnable example with package sample data
file_path <- system.file("extdata", "sample_rb.csv", package = "writeAlizer")
rb_file   <- import_rb(file_path)
head(rb_file)
}
\seealso{
\code{\link{predict_quality}}
}
