% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chlamydiae.R
\docType{data}
\name{chlamydiae}
\alias{chlamydiae}
\title{Chlamydiae Sub-Taxa of Global Patterns Data}
\format{
A phyloseq object
}
\source{
\url{https://github.com/joey711/phyloseq/raw/c2605619682acb7167487f703d135d275fead748/data/GlobalPatterns.RData}
}
\usage{
data(chlamydiae)
}
\description{
A \code{phyloseq} class object containing
 data on 16s rRNA diversity within the Chlamydiae
 bacteria taxon, originally appearing in PNAS.
}
\details{
A small subtree of the GlobalPatterns dataset, originaly available in the
phyloseq package.
}
\examples{
if (requireNamespace("phyloseq", quietly = TRUE)) {
 data(chlamydiae)
}
}
\references{
McMurdie P.J., Holmes S. (2013). phyloseq: A Bioconductor Package for
Handling and Analysis of High-Throughput Phylogenetic
Sequence Data. PLoS ONE 8(4): e61217. \url{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0061217}.

Caporaso, J. G., et al. (2011). Global patterns of 16S rRNA
diversity at a depth of millions of sequences per sample. PNAS,
108, 4516-4522. PMCID: PMC3063599

This can be viewed/downloaded at:
\url{https://www.pnas.org/content/108/suppl.1/4516.short}
Sankaran, K and Holmes, S. structSSI: Simultaneous and Selective
Inference for Grouped or Hierarchically Structured Data. Journal of
Statistical Software, 59(13), 1-21. 2014. https://jstatsoft.org/v59/i13/
}
