% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_methods.R
\name{tidy.std_glm}
\alias{tidy.std_glm}
\title{Provide tidy output from a std_glm object for use in downstream computations}
\usage{
\method{tidy}{std_glm}(x, ...)
}
\arguments{
\item{x}{An object of class std_glm}

\item{...}{Not currently used}
}
\value{
A data.frame
}
\description{
Tidy summarizes information about the components of the standardized regression fit.
}
\examples{
set.seed(6)
n <- 100
Z <- rnorm(n)
X <- rnorm(n, mean = Z)
Y <- rbinom(n, 1, prob = (1 + exp(X + Z))^(-1))
dd <- data.frame(Z, X, Y)
x <- standardize_glm(
  formula = Y ~ X * Z,
  family = "binomial",
  data = dd,
  values = list(X = 0:1),
  contrasts = c("difference", "ratio"),
  reference = 0
)
tidy(x)

}
