% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_check.R
\name{pkg_check}
\alias{pkg_check}
\title{tests a package - runs R CMD check}
\usage{
pkg_check(
  pkgid,
  src_pkgs = get_srcpkgs(),
  lib = ".check",
  roxygen = TRUE,
  quiet = FALSE,
  error_on = "error",
  check_system_clock = FALSE,
  ...
)
}
\arguments{
\item{pkgid}{a package name, path or package object}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{lib}{directory where to install and find installed pkgs}

\item{roxygen}{whether to roxygenize}

\item{quiet}{whether to be quiet/silent}

\item{error_on}{passed to \code{devtools::check()}}

\item{check_system_clock}{if FALSE, disable the \verb{_R_CHECK_SYSTEM_CLOCK_} check. This check
sometimes fail because of firewalls...}

\item{...}{passed to \code{devtools::check()}}
}
\value{
the results as a \code{pkg_test} object, or NULL if no tests found
}
\description{
This function will check a source package.
}
\examples{
\donttest{
 pkg <- setup_and_get_dummy_srcpkg()
 res <- pkg_check(pkg, lib = tempfile(), error_on = "never")
 print(res)
}
}
