% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{apply_metrics}
\alias{apply_metrics}
\title{Apply a list of functions to a data table of forecasts}
\usage{
apply_metrics(forecast, metrics, ...)
}
\arguments{
\item{forecast}{A forecast object (a validated data.table with predicted and
observed values).}

\item{metrics}{A named list of scoring functions. Names will be used as
column names in the output. See \code{\link[=get_metrics]{get_metrics()}} for more information on the
default metrics used. See the \emph{Customising metrics} section below for
information on how to pass custom arguments to scoring functions.}

\item{...}{Additional arguments to be passed to the scoring rules. Note that
this is currently not used, as all calls to \code{apply_scores} currently
avoid passing arguments via \code{...} and instead expect that the metrics
directly be modified using \code{\link[purrr:partial]{purrr::partial()}}.}
}
\value{
A data table with the forecasts and the calculated metrics.
}
\description{
This helper function applies scoring rules (stored as a list of
functions) to a data table of forecasts. \code{apply_metrics} is used within
\code{score()} to apply all scoring rules to the data.
Scoring rules are wrapped in \code{\link[=run_safely]{run_safely()}} to catch errors and to make
sure that only arguments are passed to the scoring rule that are actually
accepted by it.
}
\keyword{internal}
