% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.heatmap.R
\name{crossq.heatmap}
\alias{crossq.heatmap}
\title{Heatmap of Cross-Quantilogram}
\usage{
crossq.heatmap(
  DATA,
  k,
  vec.q,
  Bsize,
  sigLev = 0.05,
  var1_name = NULL,
  var2_name = NULL,
  title = "Cross-Quantilogram Heatmap",
  subtitle = NULL,
  colors = c("blue", "lightblue", "white", "pink", "red"),
  color_values = c(-1, -0.15, 0, 0.15, 1),
  tile_border_color = "black",
  tile_border_width = 0.5,
  x_angle = 90,
  x_lab = NULL,
  y_lab = NULL,
  legend_title = "Cross-Q"
)
}
\arguments{
\item{DATA}{An input matrix of dimensions T x 2, where T is the number of observations.
Column 1 contains the first variable and Column 2 contains the second variable.
This function will apply a k-period lag to the second variable during computation.}

\item{k}{An integer representing the lag.}

\item{vec.q}{A numeric vector of quantiles.}

\item{Bsize}{Bootstrap sample size for stationary bootstrap.}

\item{sigLev}{Significance level for statistical test. Default is 0.05 (5\% significance level).}

\item{var1_name}{Name of the first variable (predicted variable). If NULL, defaults to "Variable 1".}

\item{var2_name}{Name of the second variable (predicting variable). If NULL, defaults to "Variable 2".}

\item{title}{Plot title. Default is "Cross-Quantilogram Heatmap".}

\item{subtitle}{Plot subtitle. Default is NULL (no subtitle).}

\item{colors}{A vector of colors for the heatmap. Default is c("blue", "lightblue", "white", "pink", "red").}

\item{color_values}{A vector of values for color scaling. Default is c(-1, -0.15, 0, 0.15, 1).}

\item{tile_border_color}{Color for tile borders. Default is "black".}

\item{tile_border_width}{Width for tile borders. Default is 0.5.}

\item{x_angle}{Angle for x-axis labels. Default is 90.}

\item{x_lab}{X-axis label. If NULL (default), it's automatically generated.}

\item{y_lab}{Y-axis label. If NULL (default), it's automatically generated.}

\item{legend_title}{Title for the legend. Default is "Cross-Q".}
}
\value{
A list containing two elements:
\item{plot}{A ggplot object representing the cross-quantilogram heatmap.}
\item{df.res}{A data frame containing cross-quantilogram values and critical values. It includes the following columns:
\itemize{
\item Quantile1: The quantile values for the first variable.
\item Quantile2: The quantile values for the second variable.
\item vCRQ: The cross-quantilogram values.
\item Lower_CV: The lower critical values.
\item Upper_CV: The upper critical values.
\item Significant: A logical vector indicating whether the cross-quantilogram is significant at the given significance level.
}
}
}
\description{
This function creates a customizable heatmap visualization of the cross-quantilogram matrix
and returns a list containing the plot and a data frame of cross-quantilogram values with critical values.
The heatmap uses 0 values if the test of no correlation
cannot be rejected, and it uses cross-quantilogram values otherwise.
The critical values are obtained by stationary bootstrap.
}
\examples{
\dontrun{
## data source 
data("sys.risk") 

## two variables data: T x 2 
DATA = sys.risk[,c("JPM", "Market")]

## setup and estimation 
k = 1                             ## lag order 
vec.q  = seq(0.05, 0.95, 0.05)    ## a list of quantiles 
B.size = 200                      ## Repetition of bootstrap  
res = crossq.heatmap(DATA, k, vec.q, B.size) 

## result 
print(res$plot)
}

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series." \emph{Journal of Econometrics}, 193(1), 251-270.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
