% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportRank.R
\name{reportRank}
\alias{reportRank}
\title{Function to report ranks of 13 criteria for practical significance}
\usage{
reportRank(
  y,
  bigx,
  yesLatex = 1,
  yes13 = rep(1, 13),
  bsign = 0,
  dig = 3,
  verbo = FALSE
)
}
\arguments{
\item{y}{{ A (T x 1) vector of dependent variable data y}}

\item{bigx}{{ a (T x p) data marix of xi regressor variables associated
with the regression}}

\item{yesLatex}{{default 1 means print Latex-ready Tables}}

\item{yes13}{{default vector of ones to compute all 13 measures.}}

\item{bsign}{{A (p x 1) vector of right signs of regression
coefficients. Default is bsign=0 means the right sign is the same
as the sign of the covariance, cov(y, xi) }}

\item{dig}{{digits to be printed in latex tables, default, dig=d33}}

\item{verbo}{{logical to print results by pracSig13, default=FALSE}}
}
\value{
\item{v15}{practical significance index values (sign adjusted)
 for m1 to m5 using older linear and /or bivariate methods}
 \item{v613}{practical significance index values
 for m6 to m13 newer
 comprehensive and nonlinear methods}
 \item{r15}{ranks and average rank for m1 to m5
 using older linear and /or bivariate methods}
 \item{r613}{ranks and average rank for m6 to m13 newer
 comprehensive and nonlinear methods}
}
\description{
This function generates a report based on the
regression of y on bigx.
It acknowledges that some methods for evaluating the importance
of  regressor in explaining y may give the importance value
with a wrong (unrealistic) sign. For example, m2 reports t-values. Imagine
that due to collinearity m2 value is negative when the correct
sign from prior knowledge of the subject matter is that the
coefficient should be positive, and hence the t-stat should be positive.
The wrong sign means the importance of regressor in explaining y
should be regarded as relatively less important. The larger the
absolute size of the t-stat, the less its true importance in
measuring y. The ranking of coefficients computed here
suitably deprecates the importance of the regressor
when its coefficient has the wrong sign (perverse
direction).
}
\note{
The machine learning methods are subject to random seeds.
For some seed values, m10 values from NNS.boost() rarely become
degenerate and are reported as NA or missing. In that case
the average ranking output r613 here needs adjustment.
}
\examples{
\donttest{
set.seed(9)
y=sample(1:15,replace = TRUE)
x0=sample(2:16, replace = TRUE)
x2=sample(3:17, replace = TRUE)
x3=sample(4:18,replace = TRUE)
options(np.messages=FALSE)
yes13=rep(1,13)
yes13[10]=0
reportRank(y,bigx=cbind(x0,x2,x3),yes13=yes13)
}

}
\seealso{
\code{\link{pracSig13}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
