% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{plotPP}
\alias{plotPP}
\title{Plot joint and marginal posterior distributions}
\usage{
plotPP(
  tr,
  sr,
  to,
  so,
  x = 1,
  y = 1,
  m = 0,
  v = Inf,
  thetaRange = c(tr - 3 * sr, tr + 3 * sr),
  alphaRange = c(0, 1),
  nGrid = 100,
  plot = TRUE,
  CI = FALSE,
  ...
)
}
\arguments{
\item{tr}{Effect estimate of the replication study.}

\item{sr}{Standard error of the replication effect estimate.}

\item{to}{Effect estimate of the original study.}

\item{so}{Standard error of the replication effect estimate.}

\item{x}{Number of successes parameter of beta prior for \eqn{\alpha}{alpha}.
Defaults to \code{1}.}

\item{y}{Number of failures parameter of beta prior for \eqn{\alpha}{alpha}.
Defaults to \code{1}.}

\item{m}{Mean parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{0}.}

\item{v}{Variance parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{Inf} (uniform prior).}

\item{thetaRange}{Range of effect sizes. Defaults to three standard errors
around the replication effect estimate.}

\item{alphaRange}{Range of power parameters. Defaults to the range between
zero and one.}

\item{nGrid}{Number of grid points. Defaults to \code{100}.}

\item{plot}{Logical indicating whether data should be plotted. If
\code{FALSE} only the data used for plotting are returned.}

\item{CI}{Logical indicating whether 95\% highest posterior credible
intervals should be plotted. Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to \code{stats::integrate} for
computation of posterior densities and highest posterior density credible
intervals.}
}
\value{
Plots joint and marginal posterior densities, invisibly returns a
    list with the data for the plots.
}
\description{
This convenience function computes and, if desired, visualizes
    the joint posterior density of effect size \eqn{\theta}{theta} and power
    parameter \eqn{\alpha}{alpha}, as well as the marginal posterior
    densities of effect size \eqn{\theta}{theta} and power parameter
    \eqn{\alpha}{alpha} individually. See the functions \code{\link{postPP}},
    \code{\link{postPPalpha}}, and \code{\link{postPPtheta}} for more details
    on their computation.
}
\examples{
plotPP(tr = 0.2, sr = 0.05, to = 0.15, so = 0.05)
}
\seealso{
\code{\link{postPP}}, \code{\link{postPPalpha}}, \code{\link{postPPtheta}}
}
\author{
Samuel Pawel
}
