% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{bfPPtheta}
\alias{bfPPtheta}
\title{Bayes factor for testing effect size}
\usage{
bfPPtheta(tr, sr, to, so, x = 1, y = 1, alpha = NA, ...)
}
\arguments{
\item{tr}{Effect estimate of the replication study.}

\item{sr}{Standard error of the replication effect estimate.}

\item{to}{Effect estimate of the original study.}

\item{so}{Standard error of the replication effect estimate.}

\item{x}{Number of successes parameter for beta prior of power parameter
under \eqn{H_1}{H1}. Defaults to \code{1}. Is only taken into account when
\code{alpha = NA}.}

\item{y}{Number of failures parameter for beta prior of power parameter under
\eqn{H_1}{H1}. Defaults to \code{1}. Is only taken into account when \code{alpha
= NA}.}

\item{alpha}{Power parameter under \eqn{H_1}{H1}. Can be set to a number
between 0 and 1. Defaults to \code{NA}.}

\item{...}{Additional arguments passed to \code{stats::integrate}.}
}
\value{
Bayes factor (BF > 1 indicates evidence for \eqn{H_0}{H0}, whereas BF
    < 1 indicates evidence for \eqn{H_1}{H1})
}
\description{
This function computes the Bayes factor contrasting
    \eqn{H_0\colon \theta = 0}{H0: theta = 0} to \eqn{H_1\colon \theta \sim
    f(\theta | \code{to}, \code{so}, \alpha)}{H1: theta ~ f(theta|original
    data, alpha)} for the replication data assuming a normal likelihood. The
    prior of the effect size \eqn{\theta}{theta} under \eqn{H_1}{H1} is the
    posterior of the effect size obtained from combining a normal likelihood
    of the original data raised to the power of \eqn{\alpha}{alpha} with a
    flat initial prior with a. Under \eqn{H_1}{H1}, the power parameter can
    either be fixed to some value between 0 and 1, or it can have a beta
    distribution \eqn{\alpha | H_1 \sim \mbox{Beta}(\code{x},
    \code{y})}{alpha|H1 ~ Beta(x, y)}.
}
\examples{
## uniform prior on power parameter
bfPPtheta(tr = 0.09,  sr = 0.0518, to = 0.205, so = 0.0506)

## power parameter fixed to alpha = 1
bfPPtheta(tr = 0.090, sr = 0.0518, to = 0.205, so = 0.0506, alpha = 1)
}
\seealso{
\code{\link{bfPPalpha}}
}
\author{
Samuel Pawel
}
