% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_list_state_machine_versions}
\alias{sfn_list_state_machine_versions}
\title{Lists versions for the specified state machine Amazon Resource Name
(ARN)}
\usage{
sfn_list_state_machine_versions(
  stateMachineArn,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine.}

\item{nextToken}{If \code{nextToken} is returned, there are more results available. The value
of \code{nextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours. Using
an expired pagination token will return an \emph{HTTP 400 InvalidToken}
error.}

\item{maxResults}{The maximum number of results that are returned per call. You can use
\code{nextToken} to obtain further pages of results. The default is 100 and
the maximum allowed page size is 1000. A value of 0 uses the default.

This is only an upper limit. The actual number of results returned per
call might be fewer than the specified maximum.}
}
\description{
Lists \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html}{versions} for the specified state machine Amazon Resource Name (ARN).

See \url{https://www.paws-r-sdk.com/docs/sfn_list_state_machine_versions/} for full documentation.
}
\keyword{internal}
