% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setInvertedAxes}
\alias{setInvertedAxes}
\title{Axis orientation}
\usage{
setInvertedAxes(id, invertedAxes)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{invertedAxes}{Vector of boolean (one for each data column),
\code{TRUE} if axis orientation must be inverted;
\code{NULL} is allowed, meaning no axis must be inverted.
A named list can also be provided to only indicate which axes must be assigned
to a new orientation.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which axes have to be displayed with an inverted orientation.
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
     checkboxInput("orientationCB", "Axis orientation", FALSE),
     p("The check box controls the orientation of axes"),
     parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
     output$parPlot <- renderParallelPlot({
       parallelPlot(iris)
     })
     observeEvent(input$orientationCB, {
       invertedAxes <- rep(input$orientationCB, ncol(iris))
       parallelPlot::setInvertedAxes("parPlot", invertedAxes)
     })
   }

   shinyApp(ui, server)
 }

}
