% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{highlightRow}
\alias{highlightRow}
\title{Row highlight}
\usage{
highlightRow(id, rowIndex)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{rowIndex}{index of the row to highlight; \code{NULL} means no row is to highlight.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Asks to change the highlighted row.
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
     actionButton("highlightRowAction", "Highlight Last Row"),
     actionButton("clearHlRowAction", "Remove Highlighting"),
     p("These buttons sets/unsets a selected line"),
     parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
     output$parPlot <- renderParallelPlot({
       parallelPlot(iris)
     })
     observeEvent(input$highlightRowAction, {
       lastRowIndex <- nrow(iris)
       parallelPlot::highlightRow("parPlot", lastRowIndex)
     })

     observeEvent(input$clearHlRowAction, {
       parallelPlot::highlightRow("parPlot", NULL)
     })
   }

   shinyApp(ui, server)
 }

}
