% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pated.R
\name{pated}
\alias{pated}
\title{Prognostic Variables Assisted Treatment Effect Detection}
\usage{
pated(..., family, data)
}
\arguments{
\item{...}{formulas of models to be fitted, or moment functions for gmm.}

\item{family}{a character vector of families to be used in the models.
Currently only \code{gaussian}, \code{binomial}, \code{coxph} and \code{gmm} are supported.
\code{long} for longitudinal data may be supported in the future.
\code{family} can be of length 1 if all models are fitted in thesame family;
otherwise family should be specified for each of the models in \code{...}.}

\item{data}{a data frame if all models are fitted on the same dataset;
otherwise a list of data frames for fitting models in \code{...}. Note that a
dataset can be used to fit multiple models, thus, \code{length(data)} is unnecessary
to be equal to the number of models in \code{...}. The row names in a data frame
are treated as sample IDs. Consequently, for any two records in different
data frames that correspond to the same sample, their row names should be
consistent.}
}
\value{
a data frame of testing results.
}
\description{
\code{pated} is a wrapper function of \code{multipleOutcomes} for testing treatment effect
in randomized clinical trials. It assumes that prognostic variables are fully
randomized. This assumption can help enhancing statistical power of conventional
approaches in detecting the treatment effect. Specifically, the sensitivity
of the conventional models specified in \code{...} are improved by \code{pated}.
}
\examples{
# see vignettes
}
