% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kl_bidirectional.R
\name{kl_bidirectional}
\alias{kl_bidirectional}
\title{Bidirectional Kullback-Leibler Divergence for Genetic Markers}
\usage{
kl_bidirectional(data1, data2, minFreq = 1e-10)
}
\arguments{
\item{data1}{A data frame with allele frequencies for the first population.
First column should be "Allele", subsequent columns are marker frequencies.}

\item{data2}{A data frame with allele frequencies for the second population.
Same format as \code{data1}.}

\item{minFreq}{Numeric. Minimum frequency value to replace zeros (to avoid
undefined logarithms). Default: 1e-10.}
}
\value{
A named list with two elements:
\itemize{
\item \code{"KL from data1 to data2"}: KL(P || Q) - divergence from
population 1 to population 2
\item \code{"KL from data2 to data1"}: KL(Q || P) - divergence from
population 2 to population 1
}
Values are computed using log base 10.
}
\description{
Computes the Kullback-Leibler (KL) divergence between allele frequency
distributions of two populations. Calculates divergence in both directions
to assess asymmetric differences between populations.
}
\details{
The KL divergence measures how one probability distribution differs from
another. It is asymmetric: KL(P || Q) != KL(Q || P).

Higher values indicate greater divergence between populations, which may
affect the reliability of LR calculations when using frequency data from
one population to analyze individuals from another.

The function:
\enumerate{
\item Finds markers common to both populations
\item Merges allele frequency tables
\item Replaces missing/zero frequencies with \code{minFreq}
\item Normalizes frequencies to sum to 1
\item Computes KL divergence in both directions
}
}
\examples{
# Compare Argentina and Bosnia-Herzegovina populations
result <- kl_bidirectional(Argentina, BosniaHerz)
print(result)

# Compare Argentina and Europe
kl_bidirectional(Argentina, Europe)
}
\references{
Kullback S, Leibler RA (1951). "On Information and Sufficiency."
\emph{The Annals of Mathematical Statistics}, 22(1), 79-86.
}
\seealso{
\code{\link{kl_multi}} for comparing multiple populations,
\code{\link{kl_pie}} for matrix-based KL divergence.
}
