% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independent_response.R
\name{independent_response}
\alias{independent_response}
\title{Calculate independent responses of each variables.}
\usage{
independent_response(model, var_occ, variables, si = 1000, visualize = FALSE)
}
\arguments{
\item{model}{(Any predictive model). It is \code{isolation_forest} here. It could
be the item \code{model} of \code{POIsotree} made by function \code{\link{isotree_po}}.}

\item{var_occ}{(\code{data.frame}, \code{tibble}) The \code{data.frame} style table that
include values of environmental variables at occurrence locations.}

\item{variables}{(\code{stars}) The \code{stars} of environmental variables.
It should have multiple \code{attributes} instead of \code{dims}.
If you have \code{raster} object instead, you
could use \code{\link[stars:st_as_stars]{st_as_stars}} to convert it to \code{stars} or use
\code{\link[stars:read_stars]{read_stars}} directly read source data as a \code{stars}.
You also could use item \code{variables} of \code{POIsotree} made by function
\code{\link{isotree_po}}.}

\item{si}{(\code{integer}) The number of samples to generate response curves.
If it is too small, the response curves might be biased.
The default value is \code{1000}.}

\item{visualize}{(\code{logical}) if \code{TRUE}, plot the response curves.
The default is \code{FALSE}.}
}
\value{
(\code{IndependentResponse}) A list of
\itemize{
\item{responses_cont (\code{list}) A list of response values of continuous
variables}
\item{responses_cat (\code{list}) A list of response values of categorical
variables}
}
}
\description{
Calculate the independent responses of each variables
within the model.
}
\details{
The values show how each environmental variable independently
affects the modeling prediction. They show how the predicted result
only using this variable changes as it is varied.
}
\examples{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 10,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, nthreads = 1,
  response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

independent_responses <- independent_response(
  model = mod$model,
  var_occ = mod$vars_train,
  variables = mod$variables)
plot(independent_responses)

}
\references{
\itemize{
\item{Elith, Jane,
et al. "The evaluation strip: a new and robust method for plotting predicted
responses from species distribution models." \emph{Ecological modelling}
186.3 (2005): 280-289.\doi{10.1016/j.ecolmodel.2004.12.007}}
}
}
\seealso{
\code{\link{plot.IndependentResponse}}
}
