% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode_ids.R
\name{decode_ids}
\alias{decode_ids}
\title{Decode NFL GSIS player IDs}
\usage{
decode_ids(player_ids)
}
\arguments{
\item{player_ids}{A character vector of encoded (or decoded) GSIS player IDs
in NFL play-by-play data sets loaded with \link[nflfastR]{fast_scraper} or
\code{nflfastR::build_nflfastR_pbp}.}
}
\value{
Decoded GSIS player IDs
}
\description{
This function is a wrapper around the high efficient c++
function for fast decoding of NFL GSIS player ids intended to be used within
the R package nflfastR.
}
\examples{
\donttest{
# Decode IDs including already decoded ids and NA

decode_ids(c(
  "32013030-2d30-3033-3338-3733fa30c4fa",
  NA_character_,
  "00-0033873",
  NA_character_,
  "32013030-2d30-3032-3739-3434d4d3846d"
))
}
}
