% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{yyHatPlot}
\alias{yyHatPlot}
\title{Plot y and yHat on the same scale w/reference line}
\usage{
yyHatPlot(y, yHat, ...)
}
\arguments{
\item{y}{Vector or matrix coercible to vector. Typically
will be the quantity to be predicted.}

\item{yHat}{Vector or matrix coercible to vector, same
length as y.  Typically will be the prediction.}

\item{...}{Optional additional graph parameters.}
}
\value{
Returns invisibly - only used for graphic side effects.
}
\description{
Plots y and yHat on the same scale as a
             scatterplot with a 1:1 reference line in red.
             This is useful for visually comparing actual
             data y with estimates yHat, determining
             outliers, etc.
}
\details{
Normally only makes sense with vectors, column matrices,
          or row matrices.
}
\examples{
set.seed(1)
nObs <- 80
X <- distMat(nObs,2)
A <- cbind(c(1,-1))
Y <- X \%*\% A + rnorm(nObs) # Response data
lmObj <- lm(Y ~ X)
Yhat <- predict(lmObj) # Estimated response
yyHatPlot(Y,Yhat)
}

