% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{CLRs}
\alias{CLRs}
\title{Format aesthetics for the category level regions}
\usage{
CLRs (bp,  which = 1, col = "black")
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{which}{the column name or number for which the CLRs should be displayed, with default \code{1}. Only
one variable can be selected at a time.}

\item{col}{the colours for the CLRs, with default \code{colorRampPalette(c("black","white"))}.}
}
\value{
The object of class \code{biplot} will be appended with a list called \code{CLP.aes} containing the following elements  A list with the following components is available:
\item{which}{the variable number for which the CLRs are displayed.}
\item{col}{the colours of the CLRs.}
}
\description{
This function allows the user to format the aesthetics for the category level points (CLRs).
}
\examples{
mtdf <- as.data.frame(mtcars)
mtdf$cyl <- factor(mtdf$cyl)
mtdf$vs <- factor(mtdf$vs)
mtdf$am <- factor(mtdf$am)
mtdf$gear <- factor(mtdf$gear)
mtdf$carb <- factor(mtdf$carb)
#biplot(mtdf[,-11], scaled = TRUE) |> PCO(group.aes = mtdf[,11]) |> 
#CLRs(which = 10, col = "coral") |> plot()

}
\seealso{
\code{\link{biplot}}, \code{\link{PCO}}, \code{\link{AoD}}
}
