% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pythonInterface.R
\name{RPython}
\alias{RPython}
\title{An Evaluator for the Python Interface.}
\usage{
RPython(...)
}
\arguments{
\item{...}{arguments to control whether a new evaluator is started.  Normally omitted.}
}
\description{
Returns an evaluator for the Python interface.  Starts one on the first call, or if arguments are provided;
providing argument \code{.makeNew = TRUE} will force a new evaluator.  Otherwise, the current evaluator is
returned.
}
\details{
See \code{\link{PythonInterface}} for details of the evaluator.
}
\examples{
if(okPython(TRUE)) {
  ev <- RPython()
  xx <- ev$Eval("[1, \%s, 5]", pi)
  xx
  xx$append(4.5)
  ev$Command("print \%s", xx)
}
}
