% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc.check.R
\name{uc.check}
\alias{uc.check}
\title{Check if Roots of a Polynomial Lie Outside the Unit Circle}
\usage{
uc.check(pol_, plot_output = T, print_output = T)
}
\arguments{
\item{pol_}{the vector of polynomial coefficients in increasing order.}

\item{plot_output}{Logical that defines whether to create a plot.}

\item{print_output}{Logical that defines whether to print the results.}
}
\description{
This function outputs the roots of a given polynomial. It also checks whether they lie outside the unit circle and creates a plot to illustrate the results in an intuitive way.
}
\examples{
uc.check(pol_ = c(1,0,0.999999999), plot_output = FALSE)

uc.check(pol_ = c(2,0,2.2,-3), plot_output = TRUE)
}
