% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utopiapayoffsvector.R
\name{utopiapayoffsvector}
\alias{utopiapayoffsvector}
\title{Utopia payoffs vector}
\usage{
utopiapayoffsvector(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
The utopia payoffs vector.
}
\description{
This function computes the utopia payoffs vector of a game.
}
\details{
Given \eqn{v\in G^N}, the utopia payoff of player \eqn{i\in N} is defined as
\eqn{M_i(N,v)=v(N)-v(N\backslash i)}.
}
\examples{
v <- c(0, 10, 200, 1, 4, 7, 7)
utopiapayoffsvector(v, binary = FALSE)
}
\seealso{
\link{minimalrightsvector}
}
