% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangularup.R
\name{triangularup}
\alias{triangularup}
\title{Square upper triangulation}
\usage{
triangularup(V, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{V}{A matrix.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
A square upper triangular version of the given matrix.

This function returns two outputs:
\code{SUT}, the square upper triangular matrix.
\code{pivot}, a vector indicating pivot rows.
}
\description{
This function computes a square upper triangular version of the given matrix.
}
\examples{
set.seed(58)
triangularup(matrix(sample(1:10, 16, replace = TRUE), nrow = 4, ncol = 4))
triangularup(matrix(c(7,8,5,5,3,5,4,1,3,10,4,4,6,7,8,8),byrow=TRUE, nrow = 4, ncol = 4))
triangularup(matrix(c(1,2,1,1,-2,0,1,1),byrow=TRUE, nrow = 2, ncol = 4))
triangularup(matrix(c(1,2,1,-2,0,1,3,-1,1,-2,3,3),byrow=TRUE, nrow = 4, ncol = 3))
}
