% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monotoniccheck.R
\name{monotoniccheck}
\alias{monotoniccheck}
\title{Monotonic check}
\usage{
monotoniccheck(v, binary = FALSE, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if the game is monotonic, \code{FALSE} otherwise. If \code{instance=TRUE} and the game is not monotonic, the function also returns the positions (binary order positions if \code{binary=TRUE}; lexicographic order positions otherwise) of a pair of coalitions violating monotonicity.
}
\description{
This function checks if the given game is monotonic.
}
\details{
A game \eqn{v\in G^N} is monotonic if \eqn{v(S) \le v(T)} for all \eqn{S, T \in 2^N} such that \eqn{S\subset T}.
}
\examples{
v <- c(0, 0, 1, 5, 1, 1, 2)
monotoniccheck(v, binary=FALSE, instance=TRUE)
}
\seealso{
\link{additivecheck}, \link{superadditivecheck}, \link{zeromonotoniccheck}
}
