% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additivegame.R
\name{additivegame}
\alias{additivegame}
\title{Additive game}
\usage{
additivegame(a, binary = FALSE)
}
\arguments{
\item{a}{A vector containing the player values.}

\item{binary}{A logical value. By default, \code{binary=FALSE}.}
}
\value{
The characteristic function of the associated additive game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given the value of each player, this function returns the characteristic function of the associated additive game.
}
\details{
The characteristic function of the additive game given by \eqn{a\in \mathbb{R}^n} is defined for each \eqn{S\in 2^N} by \eqn{v(S)=\sum_{i\in S}a_i}.
}
\examples{
a <- c(1,5,10,13,58)
additivegame(a, binary = FALSE)
}
\seealso{
\link{additivecheck}, \link{strategicallyequivalentcheck}, \link{superadditivecheck}
}
