#' @title Utopia payoffs vector
#' @description This function computes the utopia payoffs vector of a game.
#' @param v A characteristic function, as a vector.
#' @param binary A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.
#' @return The utopia payoffs vector.
#' @details Given \eqn{v\in G^N}, the utopia payoff of player \eqn{i\in N} is defined as
#' \eqn{M_i(N,v)=v(N)-v(N\backslash i)}.
#' @examples
#' v <- c(0, 10, 200, 1, 4, 7, 7)
#' utopiapayoffsvector(v, binary = FALSE)
#' @seealso \link{minimalrightsvector}
#' @export
utopiapayoffsvector <- function(v, binary = FALSE) { # Principio de la función

  ################################
  ### Comprobación datos entrada###
  ################################

  nC <- length(v) # Número de coaliciones.
  n <- log(nC + 1) / log(2) # Número de jugadores.
  if (n > floor(n)) {
    stop("'v' must have length 2^n-1 for some n.")
  }
  if (binary == FALSE) { # Si el juego se introdujo en lexicográfico, lo pasamos a binario.
    v <- lex2bin(v)
  }

  ################################
  ##### Creación de variables######
  ################################

  M <- c() # Utopia payoffs

  ################################
  ###### Cuerpo de la función######
  ################################
  # Utopia Payoffs:
  for (ii in 1:n) {
    M[ii] <- v[nC] - v[nC - 2^(ii - 1)] # Mi=v(N)-v(N\ i)
  }

  ################################
  ###### Salidas de la función#####
  ################################

  return(M)
} # Fin de la función
