#' @title Additive game
#' @description Given the value of each player, this function returns the characteristic function of the associated additive game.
#' @param a A vector containing the player values.
#' @param binary A logical value. By default, \code{binary=FALSE}.
#' @return The characteristic function of the associated additive game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
#' @details The characteristic function of the additive game given by \eqn{a\in \mathbb{R}^n} is defined for each \eqn{S\in 2^N} by \eqn{v(S)=\sum_{i\in S}a_i}.
#' @examples
#' a <- c(1,5,10,13,58)
#' additivegame(a, binary = FALSE)
#' @seealso \link{additivecheck}, \link{strategicallyequivalentcheck}, \link{superadditivecheck}
#' @export

additivegame <- function (a, binary = FALSE) {
  v <- c()
  n <- length(a)
  nC<- 2^n - 1 ###Liña engadida
  sa<- sum(a) ###Liña engadida
  ###Bucle na metade das coalicions
  for (S in 1:(2^(n - 1)-1)) {
    num <- S
    J <- floor(log2(num)) + 1
    Sjug <- c()
    for (ii in 1:J) {
      if (num%%2 == 1) {
        Sjug <- c(Sjug, ii)
      }
      num <- num%/%2
    }
    v[S] <- sum(a[Sjug])
    v[nC-S] <- sum(a)-v[S] ###Liña engadida
  }
  v[nC] <- sum(a) ###Liña engadida
  if (binary == FALSE) {
    return(bin2lex(v))
  }
  else {
    return(v)
  }
}
