% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.data.r
\name{initialize.data}
\alias{initialize.data}
\title{Create Simulated Sequential Data Parameter Data Frame}
\usage{
initialize.data(seed, N, t0, tf, NStrata, strataRatio, EventRate, sensitivity,
  PPVest, RR, MatchRatio, maxSampleSize, maxTest, totalAlpha, minEvents,
  AlphaSpendType, AlphaParameter, address, rate, offset)
}
\arguments{
\item{seed}{Seed used for randomization.}

\item{N}{Number of simulations to be created. Because adverse event assignment is stochastic, this number is usually at least 10,000.}

\item{t0}{Initial time point, a number in units of either days, weeks, months, or years. It is important to be consistent.}

\item{tf}{Final time point, a number in units of either days, weeks, months, or years.}

\item{NStrata}{Number of strata in the observational study design, where a "stratum" can be defined by age categories, sex, and any other defining characteristics. Event rate of the adverse event of interest is also segregated by strata and database population size is also segregated by strata. For example, a single strata might 0-17 year old females.}

\item{strataRatio}{Ratio of individuals within a single strata for exposed and unexposed individuals.  The number of elements in this list should be 2*NStrata.}

\item{EventRate}{Rate of event accrual given in events /person-time where the time constant is the same constant being used throughout the study. Additionally, the number of elements in the EventRate matrix should be equal to the NStrata.}

\item{sensitivity}{True sensitivity of the outcome of interest.  sensitivity = (true positive case) / (true positive case + false negative case).}

\item{PPVest}{True positive predictive value of outcome in the unexposed group.  PPV = (true positive case) / (true positive case + false positive case).}

\item{RR}{Intended relative risk to detect (and therefore to simulate) in the dataset.}

\item{MatchRatio}{Single numeric value. In a self-controlled risk interval design, it is the ratio of the length of the control window to the length of the risk window.}

\item{maxSampleSize}{Maximum number of events before sequential analysis is ended or the upper limit on sample size expressed in terms of total number of events. This is the same variable as N from R Sequential.}

\item{maxTest}{Number of tests to perform on simulation data.}

\item{totalAlpha}{Total amount of alpha available to spend.}

\item{minEvents}{Minimum number of events needed before the null hypothesis can be rejected. Represented as M in R Sequential.}

\item{AlphaSpendType}{Method of alpha expenditure.  Available values are "Wald" or "power-type". This is the same as AlphaSpending R Sequential.}

\item{AlphaParameter}{Rho parameter for power-type alpha spending function. This is the same as rho in R Sequential.}

\item{address}{File directory where data for sequential analysis is stored for future tests.}

\item{rate}{Rate of exposure/cohort accrual.}

\item{offset}{Offset for exposure/cohort accrual.}
}
\description{
The function creates a data frame with all the needed parameters for simulation and 
initializes the simulation problem. Do not run initialize.data as a stand-alone function.
}
\examples{
initialize.data(seed=8768, N=1, t0=0, tf=2, NStrata=2, strataRatio=c(0.2, 0.3, 0.3, 0.2),
EventRate=c(0.4, 0.5), sensitivity=0.9, PPVest=0.9, RR=3.0, MatchRatio=1, maxSampleSize=200, 
maxTest=1, totalAlpha=0.05, minEvents=5, AlphaSpendType="Wald", AlphaParameter=0.5, address=getwd(),
rate=20, offset=30)
}
\keyword{sequential}
